/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.Preview;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHPullRequestReviewComment
extends GHObject
implements Reactable {
    GHPullRequest owner;
    private String body;
    private GHUser user;
    private String path;
    private int position;
    private int originalPosition;

    GHPullRequestReviewComment wrapUp(GHPullRequest owner) {
        this.owner = owner;
        return this;
    }

    public GHPullRequest getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public GHUser getUser() throws IOException {
        return this.owner.root.getUser(this.user.getLogin());
    }

    public String getPath() {
        return this.path;
    }

    public int getPosition() {
        return this.position;
    }

    public int getOriginalPosition() {
        return this.originalPosition;
    }

    @Override
    public URL getHtmlUrl() {
        return null;
    }

    protected String getApiRoute() {
        return "/repos/" + this.owner.getRepository().getFullName() + "/pulls/comments/" + this.id;
    }

    public void update(String body) throws IOException {
        new Requester(this.owner.root).method("PATCH").with("body", body).to(this.getApiRoute(), this);
        this.body = body;
    }

    public void delete() throws IOException {
        new Requester(this.owner.root).method("DELETE").to(this.getApiRoute());
    }

    @Override
    @Preview
    @Deprecated
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((GHReaction)((Object)new Requester(this.owner.root).withPreview("application/vnd.github.squirrel-girl-preview").with("content", content.getContent()).to(this.getApiRoute() + "/reactions", GHReaction.class))).wrap(this.owner.root);
    }

    @Override
    @Preview
    @Deprecated
    public PagedIterable<GHReaction> listReactions() {
        return new PagedIterable<GHReaction>(){

            @Override
            public PagedIterator<GHReaction> _iterator(int pageSize) {
                return new PagedIterator<GHReaction>(GHPullRequestReviewComment.this.owner.root.retrieve().withPreview("application/vnd.github.squirrel-girl-preview").asIterator(GHPullRequestReviewComment.this.getApiRoute() + "/reactions", GHReaction[].class, pageSize)){

                    protected void wrapUp(GHReaction[] page) {
                        for (GHReaction c : page) {
                            c.wrap(GHPullRequestReviewComment.this.owner.root);
                        }
                    }
                };
            }
        };
    }
}

