/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPerson;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.JsonTeam;
import org.kohsuke.github.JsonTeams;
import org.kohsuke.github.Poster;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHOrganization
extends GHPerson {
    public GHRepository createRepository(String name, String description, String homepage, String team, boolean isPublic) throws IOException {
        WebClient wc = this.root.createWebClient();
        HtmlPage pg = (HtmlPage)wc.getPage("https://github.com/organizations/" + this.login + "/repositories/new");
        HtmlForm f = (HtmlForm)pg.getForms().get(1);
        f.getInputByName("repository[name]").setValueAttribute(name);
        f.getInputByName("repository[description]").setValueAttribute(description);
        f.getInputByName("repository[homepage]").setValueAttribute(homepage);
        f.getSelectByName("team_id").getOptionByText(team).setSelected(true);
        f.submit((SubmittableElement)f.getButtonByCaption("Create Repository"));
        return this.refreshRepository(name);
    }

    public Map<String, GHTeam> getTeams() throws IOException {
        return this.root.retrieveWithAuth("/organizations/" + this.login + "/teams", JsonTeams.class).toMap(this);
    }

    public GHTeam createTeam(String name, Permission p, Collection<GHRepository> repositories) throws IOException {
        Poster post = new Poster(this.root).withCredential().with("team[name]", name).with("team[permission]", p.name().toLowerCase());
        for (GHRepository r : repositories) {
            post.with("team[repo_names][]", r.getOwnerName() + '/' + r.getName());
        }
        return post.to("/organizations/" + this.login + "/teams", JsonTeam.class).wrap(this);
    }

    public GHTeam createTeam(String name, Permission p, GHRepository ... repositories) throws IOException {
        return this.createTeam(name, p, Arrays.asList(repositories));
    }

    public List<GHRepository> getRepositoriesWithOpenPullRequests() throws IOException {
        WebClient wc = this.root.createWebClient();
        HtmlPage pg = (HtmlPage)wc.getPage("https://github.com/organizations/" + this.login + "/dashboard/pulls");
        ArrayList<GHRepository> r = new ArrayList<GHRepository>();
        for (HtmlAnchor e : pg.getElementById("js-issue-list").selectNodes(".//UL[@class='smallnav']/LI[not(@class='zeroed')]/A")) {
            String a = e.getHrefAttribute();
            String name = a.substring(a.lastIndexOf(47) + 1);
            r.add(this.getRepository(name));
        }
        return r;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        ArrayList<GHPullRequest> all = new ArrayList<GHPullRequest>();
        for (GHRepository r : this.getRepositoriesWithOpenPullRequests()) {
            all.addAll(r.getPullRequests(GHIssueState.OPEN));
        }
        return all;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Permission {
        ADMIN,
        PUSH,
        PULL;

    }
}

