/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHBlobBuilder {
    private final GHRepository repo;
    private final Requester req;

    GHBlobBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = new Requester(repo.root);
    }

    public GHBlobBuilder textContent(String content) {
        this.req.with("content", content);
        this.req.with("encoding", "utf-8");
        return this;
    }

    public GHBlobBuilder binaryContent(byte[] content) {
        String base64Content = Base64.encodeBase64String((byte[])content);
        this.req.with("content", base64Content);
        this.req.with("encoding", "base64");
        return this;
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/git/blobs", this.repo.getOwnerName(), this.repo.getName());
    }

    public GHBlob create() throws IOException {
        return (GHBlob)((Object)this.req.method("POST").to(this.getApiTail(), GHBlob.class));
    }
}

