/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHProjectColumn;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHProject
extends GHObject {
    protected GitHub root;
    protected GHObject owner;
    private String owner_url;
    private String html_url;
    private String node_id;
    private String name;
    private String body;
    private int number;
    private String state;
    private GHUser creator;

    @Override
    public URL getHtmlUrl() throws IOException {
        return GitHub.parseURL(this.html_url);
    }

    public GitHub getRoot() {
        return this.root;
    }

    public GHObject getOwner() throws IOException {
        if (this.owner == null) {
            try {
                if (this.owner_url.contains("/orgs/")) {
                    this.owner = ((GHOrganization)((Object)this.root.retrieve().to(this.getOwnerUrl().getPath(), GHOrganization.class))).wrapUp(this.root);
                } else if (this.owner_url.contains("/users/")) {
                    this.owner = ((GHUser)((Object)this.root.retrieve().to(this.getOwnerUrl().getPath(), GHUser.class))).wrapUp(this.root);
                } else if (this.owner_url.contains("/repos/")) {
                    this.owner = ((GHRepository)((Object)this.root.retrieve().to(this.getOwnerUrl().getPath(), GHRepository.class))).wrap(this.root);
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return this.owner;
    }

    public URL getOwnerUrl() {
        return GitHub.parseURL(this.owner_url);
    }

    public String getNode_id() {
        return this.node_id;
    }

    public String getName() {
        return this.name;
    }

    public String getBody() {
        return this.body;
    }

    public int getNumber() {
        return this.number;
    }

    public ProjectState getState() {
        return Enum.valueOf(ProjectState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public GHUser getCreator() {
        return this.creator;
    }

    public GHProject wrap(GHRepository repo) {
        this.owner = repo;
        this.root = repo.root;
        return this;
    }

    public GHProject wrap(GitHub root) {
        this.root = root;
        return this;
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root).withPreview("application/vnd.github.inertia-preview+json")._with(key, value).method("PATCH").to(this.getApiRoute());
    }

    protected String getApiRoute() {
        return "/projects/" + this.id;
    }

    public void setName(String name) throws IOException {
        this.edit("name", name);
    }

    public void setBody(String body) throws IOException {
        this.edit("body", body);
    }

    public void setState(ProjectState state) throws IOException {
        this.edit("state", state.toString().toLowerCase());
    }

    public void setOrganizationPermission(GHPermissionType permission) throws IOException {
        this.edit("organization_permission", permission.toString().toLowerCase());
    }

    public void setPublic(boolean isPublic) throws IOException {
        this.edit("public", isPublic);
    }

    public void delete() throws IOException {
        new Requester(this.root).withPreview("application/vnd.github.inertia-preview+json").method("DELETE").to(this.getApiRoute());
    }

    public PagedIterable<GHProjectColumn> listColumns() throws IOException {
        GHProject project = this;
        return this.root.retrieve().withPreview("application/vnd.github.inertia-preview+json").asPagedIterable(String.format("/projects/%d/columns", this.id), GHProjectColumn[].class, item -> item.wrap(project));
    }

    public GHProjectColumn createColumn(String name) throws IOException {
        return ((GHProjectColumn)((Object)this.root.retrieve().method("POST").withPreview("application/vnd.github.inertia-preview+json").with("name", name).to(String.format("/projects/%d/columns", this.id), GHProjectColumn.class))).wrap(this);
    }

    public static enum ProjectStateFilter {
        ALL,
        OPEN,
        CLOSED;

    }

    public static enum ProjectState {
        OPEN,
        CLOSED;

    }
}

