/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHProjectCard;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHProjectColumn
extends GHObject {
    protected GitHub root;
    protected GHProject project;
    private String name;
    private String project_url;

    @Override
    public URL getHtmlUrl() throws IOException {
        return null;
    }

    public GHProjectColumn wrap(GitHub root) {
        this.root = root;
        return this;
    }

    public GHProjectColumn wrap(GHProject project) {
        this.project = project;
        this.root = project.root;
        return this;
    }

    public GitHub getRoot() {
        return this.root;
    }

    public GHProject getProject() throws IOException {
        if (this.project == null) {
            try {
                this.project = ((GHProject)((Object)this.root.retrieve().to(this.getProjectUrl().getPath(), GHProject.class))).wrap(this.root);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return this.project;
    }

    public String getName() {
        return this.name;
    }

    public URL getProjectUrl() {
        return GitHub.parseURL(this.project_url);
    }

    public void setName(String name) throws IOException {
        this.edit("name", name);
    }

    private void edit(String key, Object value) throws IOException {
        new Requester(this.root).withPreview("application/vnd.github.inertia-preview+json")._with(key, value).method("PATCH").to(this.getApiRoute());
    }

    protected String getApiRoute() {
        return String.format("/projects/columns/%d", this.id);
    }

    public void delete() throws IOException {
        new Requester(this.root).withPreview("application/vnd.github.inertia-preview+json").method("DELETE").to(this.getApiRoute());
    }

    public PagedIterable<GHProjectCard> listCards() throws IOException {
        GHProjectColumn column = this;
        return this.root.retrieve().withPreview("application/vnd.github.inertia-preview+json").asPagedIterable(String.format("/projects/columns/%d/cards", this.id), GHProjectCard[].class, item -> item.wrap(column));
    }

    public GHProjectCard createCard(String note) throws IOException {
        return ((GHProjectCard)((Object)this.root.retrieve().method("POST").withPreview("application/vnd.github.inertia-preview+json").with("note", note).to(String.format("/projects/columns/%d/cards", this.id), GHProjectCard.class))).wrap(this);
    }

    public GHProjectCard createCard(GHIssue issue) throws IOException {
        return ((GHProjectCard)((Object)this.root.retrieve().method("POST").withPreview("application/vnd.github.inertia-preview+json").with("content_type", issue instanceof GHPullRequest ? "PullRequest" : "Issue").with("content_id", issue.getId()).to(String.format("/projects/columns/%d/cards", this.id), GHProjectCard.class))).wrap(this);
    }
}

