/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.kohsuke.github.BetaApi;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHRepositoryVariableBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.Requester;

public class GHRepositoryVariable
extends GitHubInteractiveObject {
    private static final String SLASH = "/";
    private static final String VARIABLE_NAMESPACE = "actions/variables";
    private String name;
    private String value;
    private String url;
    private String createdAt;
    private String updatedAt;

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Nonnull
    GitHub getApiRoot() {
        return Objects.requireNonNull(this.root());
    }

    static GHRepositoryVariable read(@Nonnull GHRepository repository, @Nonnull String name) throws IOException {
        GHRepositoryVariable variable = ((Requester)repository.root().createRequest().withUrlPath(repository.getApiTailUrl(VARIABLE_NAMESPACE), name)).fetch(GHRepositoryVariable.class);
        variable.url = repository.getApiTailUrl(VARIABLE_NAMESPACE);
        return variable;
    }

    @BetaApi
    static Creator create(GHRepository repository) {
        return new Creator(repository);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getUrl().concat(SLASH).concat(this.name), new String[0])).send();
    }

    @BetaApi
    public Setter set() {
        return new Setter(this);
    }

    @BetaApi
    public static class Creator
    extends GHRepositoryVariableBuilder<Creator> {
        private Creator(@Nonnull GHRepository repository) {
            super(Creator.class, repository.root(), null);
            ((Requester)this.requester.method("POST")).withUrlPath(repository.getApiTailUrl(GHRepositoryVariable.VARIABLE_NAMESPACE), new String[0]);
        }
    }

    @BetaApi
    public static class Setter
    extends GHRepositoryVariableBuilder<GHRepositoryVariable> {
        private Setter(@Nonnull GHRepositoryVariable base) {
            super(GHRepositoryVariable.class, base.getApiRoot(), base);
            ((Requester)this.requester.method("PATCH")).withUrlPath(base.getUrl().concat(GHRepositoryVariable.SLASH).concat(base.getName()), new String[0]);
        }
    }
}

