/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.internal.graphql.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class GHGraphQLResponse<T> {
    private final T data;
    private final List<GraphQLError> errors;

    @JsonCreator
    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Spotbugs also doesn't like this")
    public GHGraphQLResponse(@JsonProperty(value="data") T data, @JsonProperty(value="errors") List<GraphQLError> errors) {
        if (errors == null) {
            errors = Collections.emptyList();
        }
        this.data = data;
        this.errors = Collections.unmodifiableList(errors);
    }

    public boolean isSuccessful() {
        return this.errors.isEmpty();
    }

    public T getData() {
        if (!this.isSuccessful()) {
            throw new RuntimeException("Response not successful, data invalid");
        }
        return this.data;
    }

    public List<String> getErrorMessages() {
        return this.errors.stream().map(GraphQLError::getMessage).collect(Collectors.toList());
    }

    public static class ObjectResponse
    extends GHGraphQLResponse<Object> {
        @JsonCreator
        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="Spotbugs also doesn't like this")
        public ObjectResponse(@JsonProperty(value="data") Object data, @JsonProperty(value="errors") List<GraphQLError> errors) {
            super(data, errors);
        }
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="JSON API")
    private static class GraphQLError {
        private String message;

        private GraphQLError() {
        }

        public String getMessage() {
            return this.message;
        }
    }
}

