/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.time.Instant;
import java.util.Date;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHIssueCommentQueryBuilder {
    private final GHIssue issue;
    private final Requester req;

    GHIssueCommentQueryBuilder(GHIssue issue) {
        this.issue = issue;
        this.req = (Requester)issue.root().createRequest().withUrlPath(issue.getIssuesApiRoute() + "/comments", new String[0]);
    }

    public PagedIterable<GHIssueComment> list() {
        return this.req.toIterable(GHIssueComment[].class, item -> item.wrapUp(this.issue));
    }

    @Deprecated
    public GHIssueCommentQueryBuilder since(Date date) {
        return this.since(GitHubClient.toInstantOrNull(date));
    }

    public GHIssueCommentQueryBuilder since(Instant date) {
        this.req.with("since", GitHubClient.printInstant(date));
        return this;
    }

    public GHIssueCommentQueryBuilder since(long timestamp) {
        return this.since(Instant.ofEpochMilli(timestamp));
    }
}

