/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.BetaApi;
import org.kohsuke.github.GHArtifact;
import org.kohsuke.github.GHArtifactsIterable;
import org.kohsuke.github.GHAutolink;
import org.kohsuke.github.GHAutolinkBuilder;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHBlobBuilder;
import org.kohsuke.github.GHBranch;
import org.kohsuke.github.GHBranchSync;
import org.kohsuke.github.GHCheckRun;
import org.kohsuke.github.GHCheckRunBuilder;
import org.kohsuke.github.GHCheckRunsIterable;
import org.kohsuke.github.GHCodeownersError;
import org.kohsuke.github.GHCommit;
import org.kohsuke.github.GHCommitBuilder;
import org.kohsuke.github.GHCommitComment;
import org.kohsuke.github.GHCommitQueryBuilder;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHCommitStatus;
import org.kohsuke.github.GHCompare;
import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHContentBuilder;
import org.kohsuke.github.GHContentWithLicense;
import org.kohsuke.github.GHDeployKey;
import org.kohsuke.github.GHDeployment;
import org.kohsuke.github.GHDeploymentBuilder;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventInfo;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHHook;
import org.kohsuke.github.GHHooks;
import org.kohsuke.github.GHInvitation;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueBuilder;
import org.kohsuke.github.GHIssueEvent;
import org.kohsuke.github.GHIssueQueryBuilder;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHLicense;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHNotificationStream;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPermission;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHPersonSet;
import org.kohsuke.github.GHProject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestQueryBuilder;
import org.kohsuke.github.GHPullRequestSearchBuilder;
import org.kohsuke.github.GHRef;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHRepositoryBuilder;
import org.kohsuke.github.GHRepositoryCloneTraffic;
import org.kohsuke.github.GHRepositoryForkBuilder;
import org.kohsuke.github.GHRepositoryPublicKey;
import org.kohsuke.github.GHRepositoryRule;
import org.kohsuke.github.GHRepositoryStatistics;
import org.kohsuke.github.GHRepositoryTrafficTopReferralPath;
import org.kohsuke.github.GHRepositoryTrafficTopReferralSources;
import org.kohsuke.github.GHRepositoryVariable;
import org.kohsuke.github.GHRepositoryViewTraffic;
import org.kohsuke.github.GHStargazer;
import org.kohsuke.github.GHSubscription;
import org.kohsuke.github.GHTag;
import org.kohsuke.github.GHTagObject;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHTree;
import org.kohsuke.github.GHTreeBuilder;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHWorkflow;
import org.kohsuke.github.GHWorkflowJob;
import org.kohsuke.github.GHWorkflowRun;
import org.kohsuke.github.GHWorkflowRunQueryBuilder;
import org.kohsuke.github.GHWorkflowsIterable;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.MarkdownMode;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SkipFromToString;
import org.kohsuke.github.function.InputStreamFunction;
import org.kohsuke.github.internal.EnumUtils;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHRepository
extends GHObject {
    private boolean allowForking;
    private boolean allowMergeCommit;
    private boolean allowRebaseMerge;
    private boolean allowSquashMerge;
    private Map<String, GHCommit> commits = Collections.synchronizedMap(new WeakHashMap());
    private boolean compareUsePaginatedCommits;
    private String defaultBranch;
    private String language;
    private boolean deleteBranchOnMerge;
    private int forksCount;
    private int stargazersCount;
    private int watchersCount;
    private int size;
    private int openIssuesCount;
    private int subscribersCount;
    private String gitUrl;
    private String sshUrl;
    private String cloneUrl;
    private String svnUrl;
    private String mirrorUrl;
    private boolean hasIssues;
    private boolean hasWiki;
    private boolean fork;
    private boolean hasDownloads;
    private boolean hasPages;
    private boolean archived;
    private boolean disabled;
    private boolean hasProjects;
    private String htmlUrl;
    @JsonProperty(value="private")
    private boolean isPrivate;
    private Boolean isTemplate;
    private GHLicense license;
    private Map<Integer, GHMilestone> milestones = Collections.synchronizedMap(new WeakHashMap());
    private String nodeId;
    private String description;
    private String homepage;
    private String name;
    private String fullName;
    private GHUser owner;
    @SkipFromToString
    private GHRepoPermission permissions;
    private String pushedAt;
    private GHRepository source;
    private GHRepository parent;
    private GHRepository templateRepository;
    private String visibility;

    static GHRepository read(GitHub root, String owner, String name) throws IOException {
        return ((Requester)root.createRequest().withUrlPath("/repos/" + owner + "/" + name, new String[0])).fetch(GHRepository.class);
    }

    public void addCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "PUT", null);
    }

    public void addCollaborators(Collection<GHUser> users, GHOrganization.RepositoryRole permission) throws IOException {
        this.modifyCollaborators(users, "PUT", permission);
    }

    public void addCollaborators(GHOrganization.RepositoryRole permission, GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users), permission);
    }

    public void addCollaborators(GHUser ... users) throws IOException {
        this.addCollaborators(Arrays.asList(users));
    }

    public GHDeployKey addDeployKey(String title, String key) throws IOException {
        return this.addDeployKey(title, key, false);
    }

    public GHDeployKey addDeployKey(String title, String key, boolean readOnly) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("title", title)).with("key", key)).with("read_only", readOnly)).withUrlPath(this.getApiTailUrl("keys"), new String[0])).fetch(GHDeployKey.class).lateBind(this);
    }

    public void allowForking(boolean value) throws IOException {
        this.set().allowForking(value);
    }

    public void allowMergeCommit(boolean value) throws IOException {
        this.set().allowMergeCommit(value);
    }

    public void allowRebaseMerge(boolean value) throws IOException {
        this.set().allowRebaseMerge(value);
    }

    public void allowSquashMerge(boolean value) throws IOException {
        this.set().allowSquashMerge(value);
    }

    public void archive() throws IOException {
        this.set().archive();
        this.archived = true;
    }

    public GHAutolinkBuilder createAutolink() {
        return new GHAutolinkBuilder(this);
    }

    public GHBlobBuilder createBlob() {
        return new GHBlobBuilder(this);
    }

    @NonNull
    public GHCheckRunBuilder createCheckRun(@NonNull String name, @NonNull String headSHA) {
        return new GHCheckRunBuilder(this, name, headSHA);
    }

    public GHCommitBuilder createCommit() {
        return new GHCommitBuilder(this);
    }

    public GHCommitStatus createCommitStatus(String sha1, GHCommitState state, String targetUrl, String description) throws IOException {
        return this.createCommitStatus(sha1, state, targetUrl, description, null);
    }

    public GHCommitStatus createCommitStatus(String sha1, GHCommitState state, String targetUrl, String description, String context) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("state", state)).with("target_url", targetUrl)).with("description", description)).with("context", context)).withUrlPath(String.format("/repos/%s/%s/statuses/%s", this.getOwnerName(), this.name, sha1), new String[0])).fetch(GHCommitStatus.class);
    }

    public GHContentBuilder createContent() {
        return new GHContentBuilder(this);
    }

    public GHDeploymentBuilder createDeployment(String ref) {
        return new GHDeploymentBuilder(this, ref);
    }

    public GHRepositoryForkBuilder createFork() {
        return new GHRepositoryForkBuilder(this);
    }

    public GHHook createHook(String name, Map<String, String> config, Collection<GHEvent> events, boolean active) throws IOException {
        return GHHooks.repoContext(this, this.owner).createHook(name, config, events, active);
    }

    public GHIssueBuilder createIssue(String title) {
        return new GHIssueBuilder(this, title);
    }

    public GHLabel createLabel(String name, String color) throws IOException {
        return (GHLabel)((GHLabel.Creator)((GHLabel.Creator)((GHLabel.Creator)GHLabel.create(this).name(name)).color(color)).description("")).done();
    }

    public GHLabel createLabel(String name, String color, String description) throws IOException {
        return (GHLabel)((GHLabel.Creator)((GHLabel.Creator)((GHLabel.Creator)GHLabel.create(this).name(name)).color(color)).description(description)).done();
    }

    public GHMilestone createMilestone(String title, String description) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("title", title)).with("description", description)).withUrlPath(this.getApiTailUrl("milestones"), new String[0])).fetch(GHMilestone.class).lateBind(this);
    }

    public GHProject createProject(String name, String body) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("name", name)).with("body", body)).withUrlPath(this.getApiTailUrl("projects"), new String[0])).fetch(GHProject.class).lateBind(this);
    }

    public GHPullRequest createPullRequest(String title, String head, String base, String body) throws IOException {
        return this.createPullRequest(title, head, base, body, true);
    }

    public GHPullRequest createPullRequest(String title, String head, String base, String body, boolean maintainerCanModify) throws IOException {
        return this.createPullRequest(title, head, base, body, maintainerCanModify, false);
    }

    public GHPullRequest createPullRequest(String title, String head, String base, String body, boolean maintainerCanModify, boolean draft) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("title", title)).with("head", head)).with("base", base)).with("body", body)).with("maintainer_can_modify", maintainerCanModify)).with("draft", draft)).withUrlPath(this.getApiTailUrl("pulls"), new String[0])).fetch(GHPullRequest.class).wrapUp(this);
    }

    public GHRef createRef(String name, String sha) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("ref", name)).with("sha", sha)).withUrlPath(this.getApiTailUrl("git/refs"), new String[0])).fetch(GHRef.class);
    }

    public GHReleaseBuilder createRelease(String tag) {
        return new GHReleaseBuilder(this, tag);
    }

    public void createSecret(String secretName, String encryptedValue, String publicKeyId) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("encrypted_value", encryptedValue)).with("key_id", publicKeyId)).withUrlPath(this.getApiTailUrl("actions/secrets") + "/" + secretName, new String[0])).send();
    }

    public GHTagObject createTag(String tag, String message, String object, String type) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("tag", tag)).with("message", message)).with("object", object)).with("type", type)).withUrlPath(this.getApiTailUrl("git/tags"), new String[0])).fetch(GHTagObject.class).wrap(this);
    }

    public GHTreeBuilder createTree() {
        return new GHTreeBuilder(this);
    }

    public void createVariable(String name, String value) throws IOException {
        ((GHRepositoryVariable.Creator)((GHRepositoryVariable.Creator)GHRepositoryVariable.create(this).name(name)).value(value)).done();
    }

    public GHHook createWebHook(URL url) throws IOException {
        return this.createWebHook(url, null);
    }

    public GHHook createWebHook(URL url, Collection<GHEvent> events) throws IOException {
        return this.createHook("web", Collections.singletonMap("url", url.toExternalForm()), events, true);
    }

    public void delete() throws IOException {
        try {
            ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiTailUrl(""), new String[0])).send();
        }
        catch (FileNotFoundException x) {
            throw (FileNotFoundException)new FileNotFoundException("Failed to delete " + this.getOwnerName() + "/" + this.name + "; might not exist, or you might need the delete_repo scope in your token: http://stackoverflow.com/a/19327004/12916").initCause(x);
        }
    }

    public void deleteAutolink(int autolinkId) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("DELETE")).withHeader("Accept", "application/vnd.github+json")).withUrlPath(String.format("/repos/%s/%s/autolinks/%d", this.getOwnerName(), this.getName(), autolinkId), new String[0])).send();
    }

    public void deleteBranchOnMerge(boolean value) throws IOException {
        this.set().deleteBranchOnMerge(value);
    }

    public void deleteHook(int id) throws IOException {
        GHHooks.repoContext(this, this.owner).deleteHook(id);
    }

    public <T> void dispatch(String eventType, @Nullable T clientPayload) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).withUrlPath(this.getApiTailUrl("dispatches"), new String[0])).with("event_type", eventType)).with("client_payload", clientPayload)).send();
    }

    public void enableDownloads(boolean v) throws IOException {
        this.set().downloads(v);
    }

    public void enableIssueTracker(boolean v) throws IOException {
        this.set().issues(v);
    }

    public void enableProjects(boolean v) throws IOException {
        this.set().projects(v);
    }

    public void enableWiki(boolean v) throws IOException {
        this.set().wiki(v);
    }

    public boolean equals(Object obj) {
        if (obj instanceof GHRepository) {
            GHRepository that = (GHRepository)obj;
            return this.getOwnerName().equals(that.getOwnerName()) && this.name.equals(that.name);
        }
        return false;
    }

    @Deprecated
    public GHRepository fork() throws IOException {
        return this.createFork().create();
    }

    @Deprecated
    public GHRepository forkTo(GHOrganization org) throws IOException {
        return this.createFork().organization(org).create();
    }

    public GHArtifact getArtifact(long id) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("actions/artifacts"), String.valueOf(id))).fetch(GHArtifact.class).wrapUp(this);
    }

    public GHBlob getBlob(String blobSha) throws IOException {
        String target = this.getApiTailUrl("git/blobs/" + blobSha);
        return ((Requester)this.root().createRequest().withUrlPath(target, new String[0])).fetch(GHBlob.class);
    }

    public GHBranch getBranch(String name) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("branches/" + name), new String[0])).fetch(GHBranch.class).wrap(this);
    }

    public Map<String, GHBranch> getBranches() throws IOException {
        TreeMap<String, GHBranch> r = new TreeMap<String, GHBranch>();
        for (GHBranch p : ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("branches"), new String[0])).toIterable(GHBranch[].class, item -> item.wrap(this)).toArray()) {
            r.put(p.getName(), p);
        }
        return r;
    }

    public PagedIterable<GHCheckRun> getCheckRuns(String ref) {
        GitHubRequest request = ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s/check-runs", this.getOwnerName(), this.name, ref), new String[0])).build();
        return new GHCheckRunsIterable(this, request);
    }

    public PagedIterable<GHCheckRun> getCheckRuns(String ref, Map<String, Object> params) {
        GitHubRequest request = ((Requester)((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s/check-runs", this.getOwnerName(), this.name, ref), new String[0])).with(params)).build();
        return new GHCheckRunsIterable(this, request);
    }

    public GHRepositoryCloneTraffic getCloneTraffic() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("/traffic/clones"), new String[0])).fetch(GHRepositoryCloneTraffic.class);
    }

    public Set<String> getCollaboratorNames() throws IOException {
        HashSet<String> r = new HashSet<String>();
        PagedIterable users = ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("collaborators"), new String[0])).toIterable(GHUser[].class, null);
        for (GHUser u : (GHUser[])users.toArray()) {
            r.add(u.login);
        }
        return r;
    }

    public Set<String> getCollaboratorNames(CollaboratorAffiliation affiliation) throws IOException {
        HashSet<String> r = new HashSet<String>();
        PagedIterable users = ((Requester)((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("collaborators"), new String[0])).with("affiliation", affiliation)).toIterable(GHUser[].class, null);
        for (GHUser u : (GHUser[])users.toArray()) {
            r.add(u.login);
        }
        return r;
    }

    public GHPersonSet<GHUser> getCollaborators() throws IOException {
        return new GHPersonSet<GHUser>((Collection<GHUser>)this.listCollaborators().toList());
    }

    public GHCommit getCommit(String sha1) throws IOException {
        GHCommit c = this.commits.get(sha1);
        if (c == null) {
            c = ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s", this.getOwnerName(), this.name, sha1), new String[0])).fetch(GHCommit.class).wrapUp(this);
            this.commits.put(sha1, c);
        }
        return c;
    }

    public GHCompare getCompare(GHBranch id1, GHBranch id2) throws IOException {
        String ownerName2;
        String ownerName1;
        GHRepository owner1 = id1.getOwner();
        GHRepository owner2 = id2.getOwner();
        if (owner1 != null && owner2 != null && !StringUtils.equals((CharSequence)(ownerName1 = owner1.getOwnerName()), (CharSequence)(ownerName2 = owner2.getOwnerName()))) {
            String qualifiedName1 = String.format("%s:%s", ownerName1, id1.getName());
            String qualifiedName2 = String.format("%s:%s", ownerName2, id2.getName());
            return this.getCompare(qualifiedName1, qualifiedName2);
        }
        return this.getCompare(id1.getName(), id2.getName());
    }

    public GHCompare getCompare(GHCommit id1, GHCommit id2) throws IOException {
        return this.getCompare(id1.getSHA1(), id2.getSHA1());
    }

    public GHCompare getCompare(String id1, String id2) throws IOException {
        Requester requester = (Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl(String.format("compare/%s...%s", id1, id2)), new String[0]);
        if (this.compareUsePaginatedCommits) {
            ((Requester)requester.with("per_page", 1)).with("page", 1);
        }
        requester.injectMappingValue("GHCompare_usePaginatedCommits", this.compareUsePaginatedCommits);
        GHCompare compare = requester.fetch(GHCompare.class);
        return compare.lateBind(this);
    }

    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    public List<GHDeployKey> getDeployKeys() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("keys"), new String[0])).toIterable(GHDeployKey[].class, item -> item.lateBind(this)).toList();
    }

    public GHDeployment getDeployment(long id) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("deployments/" + id), new String[0])).fetch(GHDeployment.class).wrap(this);
    }

    public String getDescription() {
        return this.description;
    }

    public List<GHContent> getDirectoryContent(String path) throws IOException {
        return this.getDirectoryContent(path, null);
    }

    public List<GHContent> getDirectoryContent(String path, String ref) throws IOException {
        Requester requester = this.root().createRequest();
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String target = this.getApiTailUrl("contents/" + path);
        return ((Requester)((Requester)requester.with("ref", ref)).withUrlPath(target, new String[0])).toIterable(GHContent[].class, item -> item.wrap(this)).toList();
    }

    public GHContent getFileContent(String path) throws IOException {
        return this.getFileContent(path, null);
    }

    public GHContent getFileContent(String path, String ref) throws IOException {
        Requester requester = this.root().createRequest();
        String target = this.getApiTailUrl("contents/" + path);
        return ((Requester)((Requester)requester.with("ref", ref)).withUrlPath(target, new String[0])).fetch(GHContent.class).wrap(this);
    }

    public int getForksCount() {
        return this.forksCount;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getGitTransportUrl() {
        return this.gitUrl;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public GHHook getHook(int id) throws IOException {
        return GHHooks.repoContext(this, this.owner).getHook(id);
    }

    public List<GHHook> getHooks() throws IOException {
        return GHHooks.repoContext(this, this.owner).getHooks();
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public String getHttpTransportUrl() {
        return this.cloneUrl;
    }

    public GHIssue getIssue(int number) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("issues/" + number), new String[0])).fetch(GHIssue.class).wrap(this);
    }

    public GHIssueEvent getIssueEvent(long id) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("issues/events/" + id), new String[0])).fetch(GHIssueEvent.class);
    }

    public List<GHIssue> getIssues(GHIssueState state) throws IOException {
        return this.queryIssues().state(state).list().toList();
    }

    public List<GHIssue> getIssues(GHIssueState state, GHMilestone milestone) throws IOException {
        return this.queryIssues().milestone((String)(milestone == null ? "none" : "" + milestone.getNumber())).state(state).list().toList();
    }

    public GHLabel getLabel(String name) throws IOException {
        return GHLabel.read(this, name);
    }

    public String getLanguage() {
        return this.language;
    }

    public GHCommitStatus getLastCommitStatus(String sha1) throws IOException {
        List<GHCommitStatus> v = this.listCommitStatuses(sha1).toList();
        return v.isEmpty() ? null : v.get(0);
    }

    public GHRelease getLatestRelease() throws IOException {
        try {
            return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("releases/latest"), new String[0])).fetch(GHRelease.class).wrap(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public GHLicense getLicense() throws IOException {
        GHContentWithLicense lic = this.getLicenseContent_();
        return lic != null ? lic.license : null;
    }

    public GHContent getLicenseContent() throws IOException {
        return this.getLicenseContent_();
    }

    public GHMilestone getMilestone(int number) throws IOException {
        GHMilestone m = this.milestones.get(number);
        if (m == null) {
            m = ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("milestones/" + number), new String[0])).fetch(GHMilestone.class);
            m.owner = this;
            this.milestones.put(m.getNumber(), m);
        }
        return m;
    }

    public String getMirrorUrl() {
        return this.mirrorUrl;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    public int getOpenIssueCount() {
        return this.openIssuesCount;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getOwner() throws IOException {
        return this.isOffline() ? this.owner : this.root().getUser(this.getOwnerName());
    }

    public String getOwnerName() {
        return this.owner.login != null ? this.owner.login : this.owner.name;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getParent() throws IOException {
        if (this.fork && this.parent == null) {
            this.populate();
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent;
    }

    public GHPermissionType getPermission(GHUser u) throws IOException {
        return this.getPermission(u.getLogin());
    }

    public GHPermissionType getPermission(String user) throws IOException {
        GHPermission perm = ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("collaborators/" + user + "/permission"), new String[0])).fetch(GHPermission.class);
        return perm.getPermissionType();
    }

    public GHRepositoryPublicKey getPublicKey() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("/actions/secrets/public-key"), new String[0])).fetch(GHRepositoryPublicKey.class).wrapUp(this);
    }

    public GHPullRequest getPullRequest(int number) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("pulls/" + number), new String[0])).fetch(GHPullRequest.class).wrapUp(this);
    }

    @Deprecated
    public List<GHPullRequest> getPullRequests(GHIssueState state) throws IOException {
        return this.queryPullRequests().state(state).list().toList();
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getPushedAt() {
        return GitHubClient.parseInstant(this.pushedAt);
    }

    public GHContent getReadme() throws IOException {
        Requester requester = this.root().createRequest();
        return ((Requester)requester.withUrlPath(this.getApiTailUrl("readme"), new String[0])).fetch(GHContent.class).wrap(this);
    }

    public GHRef getRef(String refName) throws IOException {
        return GHRef.read(this, refName);
    }

    public GHRef[] getRefs() throws IOException {
        return this.listRefs().toArray();
    }

    public GHRef[] getRefs(String refType) throws IOException {
        return this.listRefs(refType).toArray();
    }

    public GHRelease getRelease(long id) throws IOException {
        try {
            return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("releases/" + id), new String[0])).fetch(GHRelease.class).wrap(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public GHRelease getReleaseByTagName(String tag) throws IOException {
        try {
            return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("releases/tags/" + tag), new String[0])).fetch(GHRelease.class).wrap(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public int getSize() {
        return this.size;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getSource() throws IOException {
        if (this.fork && this.source == null) {
            this.populate();
        }
        if (this.source == null) {
            return null;
        }
        return this.source;
    }

    public String getSshUrl() {
        return this.sshUrl;
    }

    public int getStargazersCount() {
        return this.stargazersCount;
    }

    public GHRepositoryStatistics getStatistics() {
        return new GHRepositoryStatistics(this);
    }

    public int getSubscribersCount() {
        return this.subscribersCount;
    }

    public GHSubscription getSubscription() throws IOException {
        try {
            return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("subscription"), new String[0])).fetch(GHSubscription.class).wrapUp(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String getSvnUrl() {
        return this.svnUrl;
    }

    public GHTagObject getTagObject(String sha) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("git/tags/" + sha), new String[0])).fetch(GHTagObject.class).wrap(this);
    }

    public Set<GHTeam> getTeams() throws IOException {
        GHOrganization org = this.root().getOrganization(this.getOwnerName());
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("teams"), new String[0])).toIterable(GHTeam[].class, item -> item.wrapUp(org)).toSet();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHRepository getTemplateRepository() {
        return this.templateRepository;
    }

    public List<GHRepositoryTrafficTopReferralPath> getTopReferralPaths() throws IOException {
        return Arrays.asList(((Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath(this.getApiTailUrl("/traffic/popular/paths"), new String[0])).fetch(GHRepositoryTrafficTopReferralPath[].class));
    }

    public List<GHRepositoryTrafficTopReferralSources> getTopReferralSources() throws IOException {
        return Arrays.asList(((Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath(this.getApiTailUrl("/traffic/popular/referrers"), new String[0])).fetch(GHRepositoryTrafficTopReferralSources[].class));
    }

    public GHTree getTree(String sha) throws IOException {
        String url = String.format("/repos/%s/%s/git/trees/%s", this.getOwnerName(), this.name, sha);
        return ((Requester)this.root().createRequest().withUrlPath(url, new String[0])).fetch(GHTree.class).wrap(this);
    }

    public GHTree getTreeRecursive(String sha, int recursive) throws IOException {
        String url = String.format("/repos/%s/%s/git/trees/%s", this.getOwnerName(), this.name, sha);
        return ((Requester)((Requester)this.root().createRequest().with("recursive", recursive)).withUrlPath(url, new String[0])).fetch(GHTree.class).wrap(this);
    }

    public GHRepositoryVariable getVariable(String name) throws IOException {
        return GHRepositoryVariable.read(this, name);
    }

    public GHRepositoryViewTraffic getViewTraffic() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("/traffic/views"), new String[0])).fetch(GHRepositoryViewTraffic.class);
    }

    public Visibility getVisibility() {
        if (this.visibility == null) {
            try {
                this.populate();
            }
            catch (IOException e) {
                throw new GHException("Could not populate the visibility of the repository", e);
            }
        }
        return Visibility.from(this.visibility);
    }

    public int getWatchersCount() {
        return this.watchersCount;
    }

    public GHWorkflow getWorkflow(String nameOrId) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("actions/workflows"), nameOrId)).fetch(GHWorkflow.class).wrapUp(this);
    }

    public GHWorkflow getWorkflow(long id) throws IOException {
        return this.getWorkflow(String.valueOf(id));
    }

    public GHWorkflowJob getWorkflowJob(long id) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("/actions/jobs"), String.valueOf(id))).fetch(GHWorkflowJob.class).wrapUp(this);
    }

    public GHWorkflowRun getWorkflowRun(long id) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("actions/runs"), String.valueOf(id))).fetch(GHWorkflowRun.class).wrapUp(this);
    }

    public boolean hasAdminAccess() {
        return this.permissions != null && this.permissions.admin;
    }

    public boolean hasAssignee(GHUser u) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("assignees/" + u.getLogin()), new String[0])).fetchHttpStatusCode() / 100 == 2;
    }

    public boolean hasDownloads() {
        return this.hasDownloads;
    }

    public boolean hasIssues() {
        return this.hasIssues;
    }

    public boolean hasPages() {
        return this.hasPages;
    }

    public boolean hasPermission(GHUser user, GHPermissionType permission) throws IOException {
        return this.hasPermission(user.getLogin(), permission);
    }

    public boolean hasPermission(String user, GHPermissionType permission) throws IOException {
        return this.getPermission(user).implies(permission);
    }

    public boolean hasProjects() {
        return this.hasProjects;
    }

    public boolean hasPullAccess() {
        return this.permissions != null && this.permissions.pull;
    }

    public boolean hasPushAccess() {
        return this.permissions != null && this.permissions.push;
    }

    public boolean hasWiki() {
        return this.hasWiki;
    }

    public int hashCode() {
        return ("Repository:" + this.getOwnerName() + ":" + this.name).hashCode();
    }

    public boolean isAllowForking() {
        return this.allowForking;
    }

    public boolean isAllowMergeCommit() {
        return this.allowMergeCommit;
    }

    public boolean isAllowRebaseMerge() {
        return this.allowRebaseMerge;
    }

    public boolean isAllowSquashMerge() {
        return this.allowSquashMerge;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public boolean isCollaborator(GHUser user) throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("collaborators/" + user.getLogin()), new String[0])).fetchHttpStatusCode() == 204;
    }

    public boolean isDeleteBranchOnMerge() {
        return this.deleteBranchOnMerge;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isFork() {
        return this.fork;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isTemplate() {
        if (this.isTemplate == null) {
            try {
                this.populate();
            }
            catch (IOException e) {
                throw new GHException("Could not populate the template setting of the repository", e);
            }
            this.isTemplate = Boolean.TRUE.equals(this.isTemplate);
        }
        return this.isTemplate;
    }

    public boolean isVulnerabilityAlertsEnabled() throws IOException {
        return ((Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath(this.getApiTailUrl("/vulnerability-alerts"), new String[0])).fetchHttpStatusCode() == 204;
    }

    public PagedIterable<GHArtifact> listArtifacts() {
        return new GHArtifactsIterable(this, (GitHubRequest.Builder<?>)this.root().createRequest().withUrlPath(this.getApiTailUrl("actions/artifacts"), new String[0]));
    }

    public PagedIterable<GHUser> listAssignees() {
        return this.listUsers("assignees");
    }

    public PagedIterable<GHAutolink> listAutolinks() {
        return ((Requester)((Requester)this.root().createRequest().withHeader("Accept", "application/vnd.github+json")).withUrlPath(String.format("/repos/%s/%s/autolinks", this.getOwnerName(), this.getName()), new String[0])).toIterable(GHAutolink[].class, item -> item.lateBind(this));
    }

    public List<GHCodeownersError> listCodeownersErrors() throws IOException {
        return ((Requester)this.root().createRequest().withUrlPath((String)this.getApiTailUrl((String)"codeowners/errors"), (String[])new String[0])).fetch(GHCodeownersErrors.class).errors;
    }

    public PagedIterable<GHUser> listCollaborators() {
        return this.listUsers("collaborators");
    }

    public PagedIterable<GHUser> listCollaborators(CollaboratorAffiliation affiliation) {
        return this.listUsers((Requester)this.root().createRequest().with("affiliation", affiliation), "collaborators");
    }

    public PagedIterable<GHCommitComment> listCommitComments() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/comments", this.getOwnerName(), this.name), new String[0])).toIterable(GHCommitComment[].class, item -> item.wrap(this));
    }

    public PagedIterable<GHCommitComment> listCommitComments(String commitSha) {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/commits/%s/comments", this.getOwnerName(), this.name, commitSha), new String[0])).toIterable(GHCommitComment[].class, item -> item.wrap(this));
    }

    public PagedIterable<GHCommitStatus> listCommitStatuses(String sha1) {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/statuses/%s", this.getOwnerName(), this.name, sha1), new String[0])).toIterable(GHCommitStatus[].class, null);
    }

    public PagedIterable<GHCommit> listCommits() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/commits", this.getOwnerName(), this.name), new String[0])).toIterable(GHCommit[].class, item -> item.wrapUp(this));
    }

    public PagedIterable<Contributor> listContributors() {
        return this.listContributors(null);
    }

    public PagedIterable<Contributor> listContributors(Boolean includeAnonymous) {
        return ((Requester)((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("contributors"), new String[0])).with("anon", includeAnonymous)).toIterable(Contributor[].class, null);
    }

    public PagedIterable<GHDeployment> listDeployments(String sha, String ref, String task, String environment) {
        return ((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().with("sha", sha)).with("ref", ref)).with("task", task)).with("environment", environment)).withUrlPath(this.getApiTailUrl("deployments"), new String[0])).toIterable(GHDeployment[].class, item -> item.wrap(this));
    }

    public PagedIterable<GHEventInfo> listEvents() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/events", this.getOwnerName(), this.name), new String[0])).toIterable(GHEventInfo[].class, null);
    }

    public PagedIterable<GHRepository> listForks() {
        return this.listForks(null);
    }

    public PagedIterable<GHRepository> listForks(ForkSort sort) {
        return ((Requester)((Requester)this.root().createRequest().with("sort", sort)).withUrlPath(this.getApiTailUrl("forks"), new String[0])).toIterable(GHRepository[].class, null);
    }

    public PagedIterable<GHInvitation> listInvitations() {
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/repos/%s/%s/invitations", this.getOwnerName(), this.name), new String[0])).toIterable(GHInvitation[].class, null);
    }

    public PagedIterable<GHIssueEvent> listIssueEvents() {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("issues/events"), new String[0])).toIterable(GHIssueEvent[].class, null);
    }

    public PagedIterable<GHLabel> listLabels() {
        return GHLabel.readAll(this);
    }

    public Map<String, Long> listLanguages() throws IOException {
        HashMap<String, Long> result = new HashMap<String, Long>();
        ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("languages"), new String[0])).fetch(HashMap.class).forEach((key, value) -> {
            Long addValue = -1L;
            if (value instanceof Integer) {
                addValue = (long)((Integer)value);
            }
            result.put(key.toString(), addValue);
        });
        return result;
    }

    public PagedIterable<GHMilestone> listMilestones(GHIssueState state) {
        return ((Requester)((Requester)this.root().createRequest().with("state", state)).withUrlPath(this.getApiTailUrl("milestones"), new String[0])).toIterable(GHMilestone[].class, item -> item.lateBind(this));
    }

    public GHNotificationStream listNotifications() {
        return new GHNotificationStream(this.root(), this.getApiTailUrl("/notifications"));
    }

    public PagedIterable<GHProject> listProjects() throws IOException {
        return this.listProjects(GHProject.ProjectStateFilter.OPEN);
    }

    public PagedIterable<GHProject> listProjects(GHProject.ProjectStateFilter status) {
        return ((Requester)((Requester)this.root().createRequest().with("state", status)).withUrlPath(this.getApiTailUrl("projects"), new String[0])).toIterable(GHProject[].class, item -> item.lateBind(this));
    }

    public PagedIterable<GHRef> listRefs() {
        return this.listRefs("");
    }

    public PagedIterable<GHRef> listRefs(String refType) {
        return GHRef.readMatching(this, refType);
    }

    public PagedIterable<GHRelease> listReleases() {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("releases"), new String[0])).toIterable(GHRelease[].class, item -> item.wrap(this));
    }

    public PagedIterable<GHRepositoryRule> listRulesForBranch(String branch) {
        return ((Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath(this.getApiTailUrl("/rules/branches/" + branch), new String[0])).toIterable(GHRepositoryRule[].class, null);
    }

    public PagedIterable<GHStargazer> listStargazers() {
        return ((Requester)((Requester)this.root().createRequest().withAccept("application/vnd.github.star+json")).withUrlPath(this.getApiTailUrl("stargazers"), new String[0])).toIterable(GHStargazer[].class, item -> item.wrapUp(this));
    }

    @Deprecated
    public PagedIterable<GHStargazer> listStargazers2() {
        return this.listStargazers();
    }

    public PagedIterable<GHUser> listSubscribers() {
        return this.listUsers("subscribers");
    }

    public PagedIterable<GHTag> listTags() {
        return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("tags"), new String[0])).toIterable(GHTag[].class, item -> item.wrap(this));
    }

    public List<String> listTopics() throws IOException {
        Topics topics = ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("topics"), new String[0])).fetch(Topics.class);
        return topics.names;
    }

    public PagedIterable<GHWorkflow> listWorkflows() {
        return new GHWorkflowsIterable(this);
    }

    public GHCommitQueryBuilder queryCommits() {
        return new GHCommitQueryBuilder(this);
    }

    public GHIssueQueryBuilder.ForRepository queryIssues() {
        return new GHIssueQueryBuilder.ForRepository(this);
    }

    public GHPullRequestQueryBuilder queryPullRequests() {
        return new GHPullRequestQueryBuilder(this);
    }

    public GHWorkflowRunQueryBuilder queryWorkflowRuns() {
        return new GHWorkflowRunQueryBuilder(this);
    }

    public GHAutolink readAutolink(int autolinkId) throws IOException {
        return ((Requester)((Requester)this.root().createRequest().withHeader("Accept", "application/vnd.github+json")).withUrlPath(String.format("/repos/%s/%s/autolinks/%d", this.getOwnerName(), this.getName(), autolinkId), new String[0])).fetch(GHAutolink.class).lateBind(this);
    }

    public InputStream readBlob(String blobSha) throws IOException {
        String target = this.getApiTailUrl("git/blobs/" + blobSha);
        return (InputStream)((Requester)((Requester)this.root().createRequest().withHeader("Accept", "application/vnd.github.raw")).withUrlPath(target, new String[0])).fetchStream(Requester::copyInputStream);
    }

    public <T> T readTar(InputStreamFunction<T> streamFunction, String ref) throws IOException {
        return this.downloadArchive("tar", ref, streamFunction);
    }

    public <T> T readZip(InputStreamFunction<T> streamFunction, String ref) throws IOException {
        return this.downloadArchive("zip", ref, streamFunction);
    }

    public void removeCollaborators(Collection<GHUser> users) throws IOException {
        this.modifyCollaborators(users, "DELETE", null);
    }

    public void removeCollaborators(GHUser ... users) throws IOException {
        this.removeCollaborators(Arrays.asList(users));
    }

    public void renameTo(String name) throws IOException {
        this.set().name(name);
    }

    public Reader renderMarkdown(String text, MarkdownMode mode) throws IOException {
        return new InputStreamReader((InputStream)((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("text", text)).with("mode", mode == null ? null : mode.toString())).with("context", this.getFullName())).withUrlPath("/markdown", new String[0])).fetchStream(Requester::copyInputStream), "UTF-8");
    }

    public GHPullRequestSearchBuilder searchPullRequests() {
        return new GHPullRequestSearchBuilder(this.root()).repo(this);
    }

    public Setter set() {
        return new Setter(this);
    }

    public void setCompareUsePaginatedCommits(boolean value) {
        this.compareUsePaginatedCommits = value;
    }

    public void setDefaultBranch(String value) throws IOException {
        this.set().defaultBranch(value);
    }

    public void setDescription(String value) throws IOException {
        this.set().description(value);
    }

    public void setEmailServiceHook(String address) throws IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("address", address);
        ((Requester)((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("name", "email")).with("config", config)).with("active", true)).withUrlPath(this.getApiTailUrl("hooks"), new String[0])).send();
    }

    public void setHomepage(String value) throws IOException {
        this.set().homepage(value);
    }

    public void setPrivate(boolean value) throws IOException {
        this.set().private_(value);
    }

    public void setTopics(List<String> topics) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("names", topics)).withUrlPath(this.getApiTailUrl("topics"), new String[0])).send();
    }

    public void setVisibility(Visibility value) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with("name", this.name)).with("visibility", value)).withUrlPath(this.getApiTailUrl(""), new String[0])).send();
    }

    public void star() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("PUT")).withUrlPath(String.format("/user/starred/%s", this.fullName), new String[0])).send();
    }

    public GHSubscription subscribe(boolean subscribed, boolean ignored) throws IOException {
        return ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("PUT")).with("subscribed", subscribed)).with("ignored", ignored)).withUrlPath(this.getApiTailUrl("subscription"), new String[0])).fetch(GHSubscription.class).wrapUp(this);
    }

    public GHBranchSync sync(String branch) throws IOException {
        return ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("branch", branch)).withUrlPath(this.getApiTailUrl("merge-upstream"), new String[0])).fetch(GHBranchSync.class).wrap(this);
    }

    public void unstar() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(String.format("/user/starred/%s", this.fullName), new String[0])).send();
    }

    public Updater update() {
        return new Updater(this);
    }

    @NonNull
    public GHCheckRunBuilder updateCheckRun(long checkId) {
        return new GHCheckRunBuilder(this, checkId);
    }

    private <T> T downloadArchive(@Nonnull String type, @CheckForNull String ref, @Nonnull InputStreamFunction<T> streamFunction) throws IOException {
        Objects.requireNonNull(streamFunction, "Sink must not be null");
        Object tailUrl = this.getApiTailUrl(type + "ball");
        if (ref != null) {
            tailUrl = (String)tailUrl + "/" + ref;
        }
        Requester builder = (Requester)((Requester)this.root().createRequest().method("GET")).withUrlPath((String)tailUrl, new String[0]);
        return builder.fetchStream(streamFunction);
    }

    private GHContentWithLicense getLicenseContent_() throws IOException {
        try {
            return ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl("license"), new String[0])).fetch(GHContentWithLicense.class).wrap(this);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private PagedIterable<GHUser> listUsers(Requester requester, String suffix) {
        return ((Requester)requester.withUrlPath(this.getApiTailUrl(suffix), new String[0])).toIterable(GHUser[].class, null);
    }

    private PagedIterable<GHUser> listUsers(String suffix) {
        return this.listUsers(this.root().createRequest(), suffix);
    }

    private void modifyCollaborators(@NonNull Collection<GHUser> users, @NonNull String method, @CheckForNull GHOrganization.RepositoryRole permission) throws IOException {
        Requester requester = (Requester)this.root().createRequest().method(method);
        if (permission != null) {
            requester = (Requester)((Requester)requester.with("permission", permission.toString())).inBody();
        }
        for (GHUser user : new LinkedHashSet<GHUser>(users)) {
            ((Requester)requester.withUrlPath(this.getApiTailUrl("collaborators/" + user.getLogin()), new String[0])).send();
        }
    }

    String getApiTailUrl(String tail) {
        if (((String)tail).length() > 0 && !((String)tail).startsWith("/")) {
            tail = "/" + (String)tail;
        }
        return "/repos/" + this.fullName + (String)tail;
    }

    void populate() throws IOException {
        if (this.isOffline()) {
            return;
        }
        ((Requester)this.root().createRequest().withUrlPath(this.getApiTailUrl(""), new String[0])).fetchInto(this);
    }

    @BetaApi
    public static class Setter
    extends GHRepositoryBuilder<GHRepository> {
        protected Setter(@Nonnull GHRepository repository) {
            super(GHRepository.class, repository.root(), null);
            this.requester.with("name", repository.name);
            ((Requester)this.requester.method("PATCH")).withUrlPath(repository.getApiTailUrl(""), new String[0]);
        }
    }

    public static enum Visibility {
        INTERNAL,
        PRIVATE,
        PUBLIC,
        UNKNOWN;


        public static Visibility from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Visibility.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    static class GHRepoPermission {
        boolean pull;
        boolean push;
        boolean admin;

        GHRepoPermission() {
        }
    }

    private static class GHCodeownersErrors {
        List<GHCodeownersError> errors;

        private GHCodeownersErrors() {
        }
    }

    public static class Contributor
    extends GHUser {
        private int contributions;

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int getContributions() {
            return this.contributions;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static enum ForkSort {
        NEWEST,
        OLDEST,
        STARGAZERS;

    }

    private static class Topics {
        List<String> names;

        private Topics() {
        }
    }

    @BetaApi
    public static class Updater
    extends GHRepositoryBuilder<Updater> {
        protected Updater(@Nonnull GHRepository repository) {
            super(Updater.class, repository.root(), null);
            this.requester.with("name", repository.name);
            ((Requester)this.requester.method("PATCH")).withUrlPath(repository.getApiTailUrl(""), new String[0]);
        }
    }

    public static enum CollaboratorAffiliation {
        ALL,
        DIRECT,
        OUTSIDE;

    }
}

