/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.internal.EnumUtils;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHTeamChanges {
    private FromString description;
    private FromString name;
    private FromPrivacy privacy;
    private FromRepository repository;

    public FromString getDescription() {
        return this.description;
    }

    public FromString getName() {
        return this.name;
    }

    public FromPrivacy getPrivacy() {
        return this.privacy;
    }

    public FromRepository getRepository() {
        return this.repository;
    }

    public static class FromString {
        private String from;

        public String getFrom() {
            return this.from;
        }
    }

    public static class FromPrivacy {
        private String from;

        public GHTeam.Privacy getFrom() {
            return EnumUtils.getNullableEnumOrDefault(GHTeam.Privacy.class, this.from, GHTeam.Privacy.UNKNOWN);
        }
    }

    public static class FromRepository {
        private FromRepositoryPermissions permissions;

        public FromRepositoryPermissions getPermissions() {
            return this.permissions;
        }
    }

    public static class FromRepositoryPermissions {
        private GHRepository.GHRepoPermission from;

        public boolean hadAdminAccess() {
            return this.from != null && this.from.admin;
        }

        public boolean hadPullAccess() {
            return this.from != null && this.from.pull;
        }

        public boolean hadPushAccess() {
            return this.from != null && this.from.push;
        }
    }
}

