/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.internal;

import java.util.Locale;
import java.util.logging.Logger;

public final class EnumUtils {
    private static final Logger LOGGER = Logger.getLogger(EnumUtils.class.getName());

    public static <E extends Enum<E>> E getEnumOrDefault(Class<E> enumClass, String value, E defaultEnum) {
        try {
            if (value != null) {
                return Enum.valueOf(enumClass, value.toUpperCase(Locale.ROOT));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        LOGGER.warning("Unknown value " + value + " for enum class " + enumClass.getName() + ", defaulting to " + defaultEnum.name());
        return defaultEnum;
    }

    public static <E extends Enum<E>> E getNullableEnumOrDefault(Class<E> enumClass, String value, E defaultEnum) {
        if (value == null) {
            return null;
        }
        return EnumUtils.getEnumOrDefault(enumClass, value, defaultEnum);
    }

    private EnumUtils() {
    }
}

