/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHCheckRunBuilder;
import org.kohsuke.github.GHCheckSuite;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.internal.EnumUtils;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD", "URF_UNREAD_FIELD"}, justification="JSON API")
public class GHCheckRun
extends GHObject {
    private GHApp app;
    private GHCheckSuite checkSuite;
    private String completedAt;
    private String conclusion;
    private String detailsUrl;
    private String externalId;
    private String headSha;
    private String htmlUrl;
    private String name;
    private String nodeId;
    private Output output;
    private GHPullRequest[] pullRequests = new GHPullRequest[0];
    private String startedAt;
    private String status;
    @JsonProperty(value="repository")
    GHRepository owner;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHApp getApp() {
        return this.app;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHCheckSuite getCheckSuite() {
        return this.checkSuite;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCompletedAt() {
        return GitHubClient.parseInstant(this.completedAt);
    }

    public Conclusion getConclusion() {
        return Conclusion.from(this.conclusion);
    }

    public URL getDetailsUrl() {
        return GitHubClient.parseURL(this.detailsUrl);
    }

    public String getExternalId() {
        return this.externalId;
    }

    public String getHeadSha() {
        return this.headSha;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public Output getOutput() {
        return this.output;
    }

    public List<GHPullRequest> getPullRequests() throws IOException {
        for (GHPullRequest singlePull : this.pullRequests) {
            singlePull.refresh(singlePull.getTitle());
        }
        return Collections.unmodifiableList(Arrays.asList(this.pullRequests));
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getStartedAt() {
        return GitHubClient.parseInstant(this.startedAt);
    }

    public Status getStatus() {
        return Status.from(this.status);
    }

    @NonNull
    public GHCheckRunBuilder update() {
        return new GHCheckRunBuilder(this.owner, this.getId());
    }

    GHCheckRun wrap(GHRepository owner) {
        this.owner = owner;
        this.wrap(owner.root());
        return this;
    }

    GHCheckRun wrap(GitHub root) {
        if (this.owner != null) {
            for (GHPullRequest singlePull : this.pullRequests) {
                singlePull.wrap(this.owner);
            }
        }
        if (this.checkSuite != null) {
            if (this.owner != null) {
                this.checkSuite.wrap(this.owner);
            } else {
                this.checkSuite.wrap(root);
            }
        }
        return this;
    }

    public static enum Conclusion {
        ACTION_REQUIRED,
        CANCELLED,
        FAILURE,
        NEUTRAL,
        SKIPPED,
        STALE,
        SUCCESS,
        TIMED_OUT,
        UNKNOWN;


        public static Conclusion from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Conclusion.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class Output {
        private int annotationsCount;
        private String annotationsUrl;
        private String summary;
        private String text;
        private String title;

        public int getAnnotationsCount() {
            return this.annotationsCount;
        }

        public URL getAnnotationsUrl() {
            return GitHubClient.parseURL(this.annotationsUrl);
        }

        public String getSummary() {
            return this.summary;
        }

        public String getText() {
            return this.text;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static enum Status {
        COMPLETED,
        IN_PROGRESS,
        QUEUED,
        UNKNOWN;


        public static Status from(String value) {
            return EnumUtils.getNullableEnumOrDefault(Status.class, value, UNKNOWN);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum AnnotationLevel {
        FAILURE,
        NOTICE,
        WARNING;

    }
}

