/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHIssueCommentQueryBuilder;
import org.kohsuke.github.GHIssueEvent;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHIssueStateReason;
import org.kohsuke.github.GHLabel;
import org.kohsuke.github.GHMilestone;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.SkipFromToString;
import org.kohsuke.github.internal.EnumUtils;

public class GHIssue
extends GHObject
implements Reactable {
    private static final String ASSIGNEES = "assignees";
    protected GHUser assignee;
    protected GHUser[] assignees;
    @SkipFromToString
    protected String body;
    protected String closedAt;
    protected GHUser closedBy;
    protected int comments;
    protected List<GHLabel> labels;
    protected boolean locked;
    protected GHMilestone milestone;
    protected int number;
    protected PullRequest pullRequest;
    protected String state;
    protected String stateReason;
    protected String title;
    protected String htmlUrl;
    protected GHUser user;
    GHRepository owner;

    protected static List<String> getLogins(Collection<GHUser> users) {
        ArrayList<String> names = new ArrayList<String>(users.size());
        for (GHUser a : users) {
            names.add(a.getLogin());
        }
        return names;
    }

    public void addAssignees(Collection<GHUser> assignees) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with(ASSIGNEES, GHIssue.getLogins(assignees))).withUrlPath(this.getIssuesApiRoute() + "/assignees", new String[0])).fetchInto(this);
    }

    public void addAssignees(GHUser ... assignees) throws IOException {
        this.addAssignees(Arrays.asList(assignees));
    }

    public List<GHLabel> addLabels(Collection<GHLabel> labels) throws IOException {
        return this._addLabels(GHLabel.toNames(labels));
    }

    public List<GHLabel> addLabels(GHLabel ... labels) throws IOException {
        return this.addLabels(Arrays.asList(labels));
    }

    public List<GHLabel> addLabels(String ... names) throws IOException {
        return this._addLabels(Arrays.asList(names));
    }

    public void assignTo(GHUser user) throws IOException {
        this.setAssignees(user);
    }

    public void close() throws IOException {
        this.edit("state", "closed");
    }

    public void close(GHIssueStateReason reason) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state", "closed");
        map.put("state_reason", reason.name().toLowerCase(Locale.ENGLISH));
        this.edit(map);
    }

    public GHIssueComment comment(String message) throws IOException {
        GHIssueComment r = ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("body", message)).withUrlPath(this.getIssuesApiRoute() + "/comments", new String[0])).fetch(GHIssueComment.class);
        return r.wrapUp(this);
    }

    @Override
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("content", content.getContent())).withUrlPath(this.getIssuesApiRoute() + "/reactions", new String[0])).fetch(GHReaction.class);
    }

    @Override
    public void deleteReaction(GHReaction reaction) throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getIssuesApiRoute(), "reactions", String.valueOf(reaction.getId()))).send();
    }

    public GHUser getAssignee() {
        return this.root().intern(this.assignee);
    }

    public List<GHUser> getAssignees() {
        return Collections.unmodifiableList(Arrays.asList(this.assignees));
    }

    public String getBody() {
        return this.body;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getClosedAt() {
        return GitHubClient.parseInstant(this.closedAt);
    }

    public GHUser getClosedBy() {
        if (!"closed".equals(this.state)) {
            return null;
        }
        return this.root().intern(this.closedBy);
    }

    public List<GHIssueComment> getComments() throws IOException {
        return this.listComments().toList();
    }

    public int getCommentsCount() {
        return this.comments;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public Collection<GHLabel> getLabels() {
        if (this.labels == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.labels);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHMilestone getMilestone() {
        return this.milestone;
    }

    public int getNumber() {
        return this.number;
    }

    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getRepository() {
        try {
            GHIssue gHIssue = this;
            synchronized (gHIssue) {
                if (this.owner == null) {
                    String repositoryUrlPath = this.getRepositoryUrlPath();
                    this.wrap(((Requester)this.root().createRequest().withUrlPath(repositoryUrlPath, new String[0])).fetch(GHRepository.class));
                }
            }
        }
        catch (IOException e) {
            throw new GHException("Failed to fetch repository", e);
        }
        return this.owner;
    }

    public GHIssueState getState() {
        return Enum.valueOf(GHIssueState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public GHIssueStateReason getStateReason() {
        return EnumUtils.getNullableEnumOrDefault(GHIssueStateReason.class, this.stateReason, GHIssueStateReason.UNKNOWN);
    }

    public String getTitle() {
        return this.title;
    }

    public GHUser getUser() {
        return this.root().intern(this.user);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isPullRequest() {
        return this.pullRequest != null;
    }

    public PagedIterable<GHIssueComment> listComments() {
        return ((Requester)this.root().createRequest().withUrlPath(this.getIssuesApiRoute() + "/comments", new String[0])).toIterable(GHIssueComment[].class, item -> item.wrapUp(this));
    }

    public PagedIterable<GHIssueEvent> listEvents() {
        return ((Requester)this.root().createRequest().withUrlPath(this.getRepository().getApiTailUrl(String.format("/issues/%s/events", this.number)), new String[0])).toIterable(GHIssueEvent[].class, item -> item.wrapUp(this));
    }

    @Override
    public PagedIterable<GHReaction> listReactions() {
        return ((Requester)this.root().createRequest().withUrlPath(this.getIssuesApiRoute() + "/reactions", new String[0])).toIterable(GHReaction[].class, null);
    }

    public void lock() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("PUT")).withUrlPath(this.getApiRoute() + "/lock", new String[0])).send();
    }

    public GHIssueCommentQueryBuilder queryComments() {
        return new GHIssueCommentQueryBuilder(this);
    }

    public void removeAssignees(Collection<GHUser> assignees) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root().createRequest().method("DELETE")).with(ASSIGNEES, GHIssue.getLogins(assignees))).inBody()).withUrlPath(this.getIssuesApiRoute() + "/assignees", new String[0])).fetchInto(this);
    }

    public void removeAssignees(GHUser ... assignees) throws IOException {
        this.removeAssignees(Arrays.asList(assignees));
    }

    public List<GHLabel> removeLabel(String name) throws IOException {
        return Arrays.asList(((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getIssuesApiRoute() + "/labels", name)).fetch(GHLabel[].class));
    }

    public List<GHLabel> removeLabels(Collection<GHLabel> labels) throws IOException {
        return this._removeLabels(GHLabel.toNames(labels));
    }

    public List<GHLabel> removeLabels(GHLabel ... labels) throws IOException {
        return this.removeLabels(Arrays.asList(labels));
    }

    public List<GHLabel> removeLabels(String ... names) throws IOException {
        return this._removeLabels(Arrays.asList(names));
    }

    public void reopen() throws IOException {
        this.edit("state", "open");
    }

    public void setAssignees(Collection<GHUser> assignees) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with(ASSIGNEES, GHIssue.getLogins(assignees))).withUrlPath(this.getIssuesApiRoute(), new String[0])).send();
    }

    public void setAssignees(GHUser ... assignees) throws IOException {
        this.setAssignees(Arrays.asList(assignees));
    }

    public void setBody(String body) throws IOException {
        this.edit("body", body);
    }

    public void setLabels(String ... labels) throws IOException {
        this.editIssue("labels", labels);
    }

    public void setMilestone(GHMilestone milestone) throws IOException {
        if (milestone == null) {
            this.editIssue("milestone", null);
        } else {
            this.editIssue("milestone", milestone.getNumber());
        }
    }

    public void setTitle(String title) throws IOException {
        this.edit("title", title);
    }

    public void unlock() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute() + "/lock", new String[0])).send();
    }

    private List<GHLabel> _addLabels(Collection<String> names) throws IOException {
        return Arrays.asList(((Requester)((Requester)((Requester)this.root().createRequest().with("labels", names)).method("POST")).withUrlPath(this.getIssuesApiRoute() + "/labels", new String[0])).fetch(GHLabel[].class));
    }

    private List<GHLabel> _removeLabels(Collection<String> names) throws IOException {
        List<GHLabel> remainingLabels = Collections.emptyList();
        for (String name : names) {
            try {
                remainingLabels = this.removeLabel(name);
            }
            catch (GHFileNotFoundException gHFileNotFoundException) {}
        }
        return remainingLabels;
    }

    private void edit(Map<String, Object> map) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().with(map)).method("PATCH")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    private void edit(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().with(key, value)).method("PATCH")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    private void editIssue(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().withNullable(key, value)).method("PATCH")).withUrlPath(this.getIssuesApiRoute(), new String[0])).send();
    }

    private void editNullable(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().withNullable(key, value)).method("PATCH")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    private String getRepositoryUrlPath() {
        String url = this.getUrl().toString();
        int index = url.indexOf("/issues");
        if (index == -1) {
            index = url.indexOf("/pulls");
        }
        return url.substring(0, index);
    }

    protected String getApiRoute() {
        return this.getIssuesApiRoute();
    }

    protected String getIssuesApiRoute() {
        if (this.owner == null) {
            URL url = Objects.requireNonNull(this.getUrl(), "Missing instance URL!");
            return StringUtils.prependIfMissing((String)url.toString().replace(this.root().getApiUrl(), ""), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        GHRepository repo = this.getRepository();
        return "/repos/" + repo.getOwnerName() + "/" + repo.getName() + "/issues/" + this.number;
    }

    GHIssue wrap(GHRepository owner) {
        this.owner = owner;
        if (this.milestone != null) {
            this.milestone.lateBind(owner);
        }
        return this;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class PullRequest {
        private String diffUrl;
        private String patchUrl;
        private String htmlUrl;

        public URL getDiffUrl() {
            return GitHubClient.parseURL(this.diffUrl);
        }

        public URL getPatchUrl() {
            return GitHubClient.parseURL(this.patchUrl);
        }

        public URL getUrl() {
            return GitHubClient.parseURL(this.htmlUrl);
        }
    }
}

