/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubPageIterator;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;
import org.kohsuke.github.SearchResult;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Constructed by JSON API")
public class PagedSearchIterable<T>
extends PagedIterable<T> {
    private final Class<? extends SearchResult<T>> receiverType;
    private final GitHubRequest request;
    private SearchResult<T> result;
    private final transient GitHub root;

    PagedSearchIterable(GitHub root, GitHubRequest request, Class<? extends SearchResult<T>> receiverType) {
        this.root = root;
        this.request = request;
        this.receiverType = receiverType;
    }

    @Override
    @Nonnull
    public PagedIterator<T> _iterator(int pageSize) {
        Iterator<T[]> adapter = this.adapt(GitHubPageIterator.create(this.root.getClient(), this.receiverType, this.request, pageSize));
        return new PagedIterator(adapter, null);
    }

    public int getTotalCount() {
        this.populate();
        return this.result.totalCount;
    }

    public boolean isIncomplete() {
        this.populate();
        return this.result.incompleteResults;
    }

    @Override
    public PagedSearchIterable<T> withPageSize(int size) {
        return (PagedSearchIterable)super.withPageSize(size);
    }

    private void populate() {
        if (this.result == null) {
            ((PagedIterator)this.iterator()).hasNext();
        }
    }

    protected Iterator<T[]> adapt(final Iterator<? extends SearchResult<T>> base) {
        return new Iterator<T[]>(){

            @Override
            public boolean hasNext() {
                return base.hasNext();
            }

            @Override
            public T[] next() {
                SearchResult v = (SearchResult)base.next();
                if (PagedSearchIterable.this.result == null) {
                    PagedSearchIterable.this.result = v;
                }
                return v.getItems(PagedSearchIterable.this.root);
            }
        };
    }
}

