/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.util.ArrayList;
import java.util.List;
import org.kohsuke.graph_layouter.impl.EdgeDirection;
import org.kohsuke.graph_layouter.impl.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Level<T> {
    private Level<T> next;
    private Level<T> prev;
    public final int n;
    public final ArrayList<Vertex<T>> vertices = new ArrayList();

    public Level(int n) {
        this.n = n;
    }

    public Level<T> prev() {
        return this.prev;
    }

    public Level<T> next() {
        return this.next;
    }

    public Level<T> makeNext() {
        if (this.next == null) {
            this.next = new Level<T>(this.n + 1);
            this.next.prev = this;
        }
        return this.next;
    }

    public Level<T> makePrev() {
        if (this.prev == null) {
            this.prev = new Level<T>(this.n - 1);
            this.prev.next = this;
        }
        return this.prev;
    }

    public Level<T> first() {
        Level<T> l = this;
        while (l.prev != null) {
            l = l.prev;
        }
        return l;
    }

    public Level<T> last() {
        Level<T> l = this;
        while (l.next != null) {
            l = l.next;
        }
        return l;
    }

    void assignOrder() {
        int i = 0;
        for (Vertex<T> v : this.vertices) {
            v.order = i++;
        }
    }

    public void reorder(List<Vertex<T>> newList) {
        assert (this.vertices.size() == newList.size());
        int i = 0;
        while (i < newList.size()) {
            Vertex<T> v = newList.get(i);
            this.vertices.set(i, v);
            v.order = i++;
        }
    }

    public void swap(Vertex<T> v, Vertex<T> w) {
        assert (this.vertices.get(v.order) == v);
        assert (this.vertices.get(w.order) == w);
        this.vertices.set(v.order, w);
        this.vertices.set(w.order, v);
        int t = v.order;
        v.order = w.order;
        w.order = t;
    }

    public int getAdjacentCrossings() {
        int r = this.countCrossings();
        if (this.prev != null) {
            r += this.prev.countCrossings();
        }
        return r;
    }

    public int getAdjacentSwapCrossing(Vertex<T> v, Vertex<T> w) {
        return Level.countSwapCrossing(this.prev, this, v, w, EdgeDirection.FORWARD) + Level.countSwapCrossing(this.next, this, v, w, EdgeDirection.BACKWARD);
    }

    public int countCrossings() {
        if (this.next == null) {
            return 0;
        }
        int crossing = 0;
        for (int ai = 0; ai < this.vertices.size() - 1; ++ai) {
            Vertex<T> a = this.vertices.get(ai);
            for (int bi = ai + 1; bi < this.vertices.size(); ++bi) {
                Vertex<T> b = this.vertices.get(bi);
                for (Vertex c : a.forward) {
                    for (Vertex d : b.forward) {
                        if (c.order <= d.order) continue;
                        ++crossing;
                    }
                }
            }
        }
        return crossing;
    }

    public static <T> int countSwapCrossing(Level<T> from, Level<T> to, Vertex<T> v, Vertex<T> w, EdgeDirection dir) {
        if (from == null) {
            return 0;
        }
        assert (to != null);
        assert (to.n == v.level);
        assert (to.n == w.level);
        assert (from.n + dir.sign() == to.n);
        int crossing = 0;
        for (int ai = 0; ai < from.vertices.size() - 1; ++ai) {
            Vertex<T> a = from.vertices.get(ai);
            for (int bi = ai + 1; bi < from.vertices.size(); ++bi) {
                Vertex<T> b = from.vertices.get(bi);
                for (Vertex<T> c : dir.getEdges(a)) {
                    if (c == v) {
                        c = w;
                    } else if (c == w) {
                        c = v;
                    }
                    for (Vertex<T> d : dir.getEdges(b)) {
                        if (d == v) {
                            d = w;
                        } else if (d == w) {
                            d = v;
                        }
                        if (c.order <= d.order) continue;
                        ++crossing;
                    }
                }
            }
        }
        return crossing;
    }

    public boolean contains(Vertex<T> v) {
        assert (v.level != this.n || this.vertices.get(v.order) == v);
        return v.level == this.n;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        boolean first = true;
        for (Vertex<T> v : this.vertices) {
            if (!first) {
                buf.append(',');
            }
            first = false;
            buf.append(v).append('=').append(v.pos.x);
        }
        buf.append(']');
        return buf.toString();
    }

    final class Memento {
        private final List<Vertex<T>> order;

        Memento() {
            this.order = new ArrayList(Level.this.vertices);
        }

        void restore() {
            Level.this.reorder(this.order);
        }
    }
}

