/*
 * Decompiled with CFR 0.152.
 */
package rpc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import jcifs.util.Hexdump;
import ndr.NdrBuffer;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import rpc.BasicConnectionContext;
import rpc.ConnectionContext;
import rpc.ConnectionOrientedPdu;
import rpc.Endpoint;
import rpc.FaultException;
import rpc.ProviderException;
import rpc.RpcException;
import rpc.Transport;
import rpc.core.PresentationContext;
import rpc.core.PresentationSyntax;
import rpc.core.UUID;
import rpc.pdu.AlterContextPdu;
import rpc.pdu.AlterContextResponsePdu;
import rpc.pdu.BindAcknowledgePdu;
import rpc.pdu.BindPdu;
import rpc.pdu.FaultCoPdu;
import rpc.pdu.RequestCoPdu;
import rpc.pdu.ResponseCoPdu;
import rpc.pdu.ShutdownPdu;

public class ConnectionOrientedEndpoint
implements Endpoint {
    public static final String CONNECTION_CONTEXT = "rpc.connectionContext";
    protected ConnectionContext context;
    private Transport transport;
    private PresentationSyntax syntax;
    private boolean bound;
    private int callId;
    private int contextIdCounter;
    private int contextIdToUse;
    private static final Logger logger = Logger.getLogger("org.jinterop");
    private Map uuidsVsContextIds;
    protected String currentIID;

    public ConnectionOrientedEndpoint(Transport transport, PresentationSyntax syntax) {
        this.contextIdToUse = this.contextIdCounter = 0;
        this.uuidsVsContextIds = new HashMap();
        this.currentIID = null;
        this.transport = transport;
        this.syntax = syntax;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public PresentationSyntax getSyntax() {
        return this.syntax;
    }

    public void call(int semantics, UUID object, int opnum, NdrObject ndrobj) throws IOException {
        this.bind();
        RequestCoPdu request = new RequestCoPdu();
        request.setContextId(this.contextIdToUse);
        byte[] b = new byte[1024];
        NdrBuffer buffer = new NdrBuffer(b, 0);
        NetworkDataRepresentation ndr = new NetworkDataRepresentation();
        ndrobj.encode(ndr, buffer);
        byte[] stub = new byte[buffer.getLength()];
        System.arraycopy(buffer.buf, 0, stub, 0, stub.length);
        if (logger.isLoggable(Level.FINEST)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])stub, (int)0, (int)stub.length);
            logger.finest("\n" + byteArrayOutputStream.toString());
        }
        request.setStub(stub);
        request.setAllocationHint(buffer.getLength());
        request.setOpnum(opnum);
        request.setObject(object);
        if ((semantics & 1) != 0) {
            request.setFlag(64, true);
        }
        this.send(request);
        if (request.getFlag(64)) {
            return;
        }
        ConnectionOrientedPdu reply = this.receive();
        if (reply instanceof ResponseCoPdu) {
            ndr.setFormat(reply.getFormat());
            buffer = new NdrBuffer(((ResponseCoPdu)reply).getStub(), 0);
            if (logger.isLoggable(Level.FINEST)) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Hexdump.hexdump((PrintStream)new PrintStream(byteArrayOutputStream), (byte[])buffer.buf, (int)0, (int)buffer.buf.length);
                logger.finest("\n" + byteArrayOutputStream.toString());
            }
        } else {
            if (reply instanceof FaultCoPdu) {
                FaultCoPdu fault = (FaultCoPdu)reply;
                throw new FaultException("Received fault.", fault.getStatus(), fault.getStub());
            }
            if (reply instanceof ShutdownPdu) {
                throw new RpcException("Received shutdown request from server.");
            }
            throw new RpcException("Received unexpected PDU from server.");
        }
        ndrobj.decode(ndr, buffer);
    }

    protected void rebind() throws IOException {
        this.bound = false;
        this.bind();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void bind() throws IOException {
        if (this.bound) {
            return;
        }
        if (this.context != null) {
            this.bound = true;
            try {
                Integer cid = (Integer)this.uuidsVsContextIds.get(this.getSyntax().toString().toUpperCase());
                ConnectionOrientedPdu pdu = this.context.alter(new PresentationContext(cid == null ? (this.contextIdCounter = this.contextIdCounter + 1) : cid, this.getSyntax()));
                boolean sendAlter = false;
                if (cid == null) {
                    this.uuidsVsContextIds.put(this.getSyntax().toString().toUpperCase(), new Integer(this.contextIdCounter));
                    this.contextIdToUse = this.contextIdCounter;
                    sendAlter = true;
                } else {
                    this.contextIdToUse = cid;
                }
                if (!sendAlter) return;
                if (pdu != null) {
                    this.send(pdu);
                }
                while (!this.context.isEstablished()) {
                    ConnectionOrientedPdu recieved = this.receive();
                    pdu = this.context.accept(recieved);
                    if (pdu == null) continue;
                    switch (pdu.getType()) {
                        case 12: {
                            if (((BindAcknowledgePdu)pdu).getResultList()[0].reason == 2) break;
                            this.currentIID = ((BindPdu)recieved).getContextList()[0].abstractSyntax.getUuid().toString();
                            break;
                        }
                        case 15: {
                            if (((AlterContextResponsePdu)pdu).getResultList()[0].reason == 2) break;
                            this.currentIID = ((AlterContextPdu)recieved).getContextList()[0].abstractSyntax.getUuid().toString();
                            break;
                        }
                    }
                    this.send(pdu);
                }
                return;
            }
            catch (IOException ex) {
                this.bound = false;
                throw ex;
            }
            catch (RuntimeException ex) {
                this.bound = false;
                throw ex;
            }
            catch (Exception ex) {
                this.bound = false;
                throw new IOException(ex.getMessage());
            }
        } else {
            this.connect();
        }
    }

    protected void send(ConnectionOrientedPdu request) throws IOException {
        this.bind();
        this.context.getConnection().transmit(request, this.getTransport());
    }

    protected ConnectionOrientedPdu receive() throws IOException {
        return this.context.getConnection().receive(this.getTransport());
    }

    public void detach() throws IOException {
        this.bound = false;
        this.context = null;
        this.getTransport().close();
    }

    private void connect() throws IOException {
        this.bound = true;
        this.contextIdCounter = 0;
        this.currentIID = null;
        try {
            this.uuidsVsContextIds.put(this.getSyntax().toString().toUpperCase(), new Integer(this.contextIdCounter));
            this.context = this.createContext();
            ConnectionOrientedPdu pdu = this.context.init(new PresentationContext(this.contextIdCounter, this.getSyntax()), this.getTransport().getProperties());
            this.contextIdToUse = this.contextIdCounter;
            if (pdu != null) {
                this.send(pdu);
            }
            while (!this.context.isEstablished()) {
                ConnectionOrientedPdu recieved = this.receive();
                pdu = this.context.accept(recieved);
                if (pdu == null) continue;
                switch (pdu.getType()) {
                    case 12: {
                        if (((BindAcknowledgePdu)pdu).getResultList()[0].reason == 2) break;
                        this.currentIID = ((BindPdu)recieved).getContextList()[0].abstractSyntax.getUuid().toString();
                        break;
                    }
                    case 15: {
                        if (((AlterContextResponsePdu)pdu).getResultList()[0].reason == 2) break;
                        this.currentIID = ((AlterContextPdu)recieved).getContextList()[0].abstractSyntax.getUuid().toString();
                        break;
                    }
                }
                this.send(pdu);
            }
        }
        catch (IOException ex) {
            try {
                this.detach();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            try {
                this.detach();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw ex;
        }
        catch (Exception ex) {
            try {
                this.detach();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IOException(ex.getMessage());
        }
    }

    protected ConnectionContext createContext() throws ProviderException {
        Properties properties = this.getTransport().getProperties();
        if (properties == null) {
            return new BasicConnectionContext();
        }
        String context = properties.getProperty(CONNECTION_CONTEXT);
        if (context == null) {
            return new BasicConnectionContext();
        }
        try {
            return (ConnectionContext)Class.forName(context).newInstance();
        }
        catch (Exception ex) {
            throw new ProviderException(ex.getMessage());
        }
    }
}

