/*
 * Decompiled with CFR 0.152.
 */
package com.iwombat.foundation.uuid;

import com.iwombat.foundation.uuid.UUID;
import com.iwombat.util.HexStringUtil;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

public final class UUIDFactory {
    private static final long serialVersionUID = 1L;
    private static final short OID_LENGTH = 16;
    private static final short BYTE_SHIFT = 8;
    private static final short LOW_BYTE_MASK = 255;
    private static final short LOW_NIBBLE_MASK = 15;
    private static final int MAX_SEQUENCE_NUMBER = 16384;
    private static int sequenceNumber = 0;
    private static byte[] macAddr;
    private static final short MACADDR_LENGTH = 6;
    private static Random rand;
    private static BigInteger lastTimestamp;
    private static final byte VERSION = 16;
    private static final byte VARIANT = -128;
    private static final long MILLIS_NANOS_MULT = 1000L;
    private static final long NANOSECONDS_PER_DAY = 711573504L;
    private static final long DAYS_SINCE_EPOCH = 141415L;
    private static final BigInteger TIME_OFFSET;
    private static final int GREATER_THAN = 1;
    private static final int TIME_ARRAY_LEN = 8;

    private UUIDFactory() {
    }

    private static int incrementSequence() {
        ++sequenceNumber;
        return sequenceNumber %= 16384;
    }

    private static void setTimeStamp(BigInteger time) {
        lastTimestamp = time;
    }

    private static BigInteger getTime() {
        BigInteger time = TIME_OFFSET.add(BigInteger.valueOf(1000L * System.currentTimeMillis()));
        if (1 == time.compareTo(lastTimestamp)) {
            UUIDFactory.incrementSequence();
        } else {
            UUIDFactory.setTimeStamp(time);
        }
        return time;
    }

    private static void stuffOidWithLong(byte[] tempOid, long l, int arrayPosition, int numBytes) {
        int index = arrayPosition + numBytes - 1;
        do {
            tempOid[index] = (byte)(l & 0xFFL);
            l >>>= 8;
        } while (index-- > arrayPosition);
    }

    private static byte[] getDummyMACADDR() {
        byte[] dummy = new byte[6];
        rand.nextBytes(dummy);
        dummy[0] = (byte)(dummy[0] | 0xFFFFFF80);
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            byte[] address = localhost.getAddress();
            if (127 != address[0]) {
                dummy[dummy.length - 1] = address[address.length - 1];
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return dummy;
    }

    private static void stuffOidWithBytes(byte[] oid, int oidIdx, byte[] value) {
        int idx = 0;
        while (idx < value.length) {
            oid[oidIdx++] = value[idx++];
        }
    }

    private static byte[] createTimeArray(byte[] array) {
        byte[] timeArray = new byte[8];
        for (int idx = 0; idx < array.length; ++idx) {
            timeArray[timeArray.length - idx - 1] = array[array.length - idx - 1];
        }
        return timeArray;
    }

    private static synchronized byte[] createOid() {
        long naughtyBits = 0L;
        byte[] localOid = new byte[16];
        byte[] timeArray = UUIDFactory.createTimeArray(UUIDFactory.getTime().toByteArray());
        UUIDFactory.stuffOidWithBytes(localOid, 0, timeArray);
        naughtyBits = sequenceNumber;
        UUIDFactory.stuffOidWithLong(localOid, naughtyBits, 8, 2);
        UUIDFactory.stuffOidWithBytes(localOid, 10, macAddr);
        localOid[6] = (byte)(localOid[6] & 0xF);
        localOid[6] = (byte)(localOid[6] | 0x10);
        localOid[8] = (byte)(localOid[8] & 0xF);
        localOid[8] = (byte)(localOid[8] | 0xFFFFFF80);
        return localOid;
    }

    public static UUID createUUID() {
        return new UUID(UUIDFactory.createOid());
    }

    public static UUID createUUID(byte[] byteArray) {
        return new UUID(byteArray);
    }

    public static UUID createUUID(String hexString) {
        return new UUID(hexString);
    }

    static {
        rand = new Random(System.currentTimeMillis());
        lastTimestamp = BigInteger.ZERO;
        TIME_OFFSET = BigInteger.valueOf(141415L).multiply(BigInteger.valueOf(711573504L));
        String addrString = System.getProperty("MACADDR");
        try {
            macAddr = HexStringUtil.bytesFromHexString(addrString);
        }
        catch (RuntimeException e) {
            macAddr = UUIDFactory.getDummyMACADDR();
        }
        if (macAddr.length < 6) {
            System.err.println("StartupError: MACADDR not defined properly in System.properties");
            macAddr = UUIDFactory.getDummyMACADDR();
        }
        sequenceNumber = rand.nextInt();
        sequenceNumber %= 16384;
    }
}

