/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.junit;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public final class MethodCallRecorder
implements InvocationHandler {
    private final Object proxy;
    private final List queue = new ArrayList();

    public MethodCallRecorder(Class intf) {
        this.proxy = Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, (InvocationHandler)this);
    }

    public Object getProxy() {
        return this.proxy;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.queue.add(new MethodCall(method, args));
        return null;
    }

    public void replay(Object realTarget) throws Throwable {
        for (int i = 0; i < this.queue.size(); ++i) {
            MethodCall methodCall = (MethodCall)this.queue.get(i);
            methodCall.execute(realTarget);
        }
    }

    public void clear() {
        this.queue.clear();
    }

    private static class MethodCall {
        private final Method method;
        private final Object[] args;

        MethodCall(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        void execute(Object target) throws Throwable {
            try {
                this.method.invoke(target, this.args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }
}

