/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.junit.WorkerThreadGroup;

class ParallelPrintStream
extends PrintStream {
    private final PrintStream base;
    private final Map buffer = Collections.synchronizedMap(new HashMap());

    public ParallelPrintStream(PrintStream out) {
        super(out);
        this.base = out;
    }

    public PrintStream getBase() {
        return this.base;
    }

    private Streams getStreams() {
        ThreadGroup tg;
        for (tg = Thread.currentThread().getThreadGroup(); tg != null && !(tg instanceof WorkerThreadGroup); tg = tg.getParent()) {
        }
        Streams s = (Streams)this.buffer.get(tg);
        if (s == null) {
            s = new Streams();
            this.buffer.put(tg, s);
        }
        return s;
    }

    private PrintStream out() {
        return this.getStreams().ps;
    }

    public synchronized void purge() {
        this.getStreams().purge();
    }

    public void println() {
        this.out().println();
    }

    public void print(char c) {
        this.out().print(c);
    }

    public void println(char x) {
        this.out().println(x);
    }

    public void print(double d) {
        this.out().print(d);
    }

    public void println(double x) {
        this.out().println(x);
    }

    public void print(float f) {
        this.out().print(f);
    }

    public void println(float x) {
        this.out().println(x);
    }

    public void print(int i) {
        this.out().print(i);
    }

    public void println(int x) {
        this.out().println(x);
    }

    public void print(long l) {
        this.out().print(l);
    }

    public void println(long x) {
        this.out().println(x);
    }

    public void print(boolean b) {
        this.out().print(b);
    }

    public void println(boolean x) {
        this.out().println(x);
    }

    public void print(char[] s) {
        this.out().print(s);
    }

    public void println(char[] x) {
        this.out().println(x);
    }

    public void print(Object obj) {
        this.out().print(obj);
    }

    public void println(Object x) {
        this.out().println(x);
    }

    public void print(String s) {
        this.out().print(s);
    }

    public void println(String x) {
        this.out().println(x);
    }

    public void write(byte[] b, int off, int len) {
        this.out().write(b, off, len);
    }

    public void close() {
        this.out().close();
    }

    public void flush() {
        this.out().flush();
    }

    public void write(int b) {
        this.out().write(b);
    }

    public void write(byte[] b) throws IOException {
        this.out().write(b);
    }

    private class Streams {
        private final PrintStream ps;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        Streams() {
            this.ps = new PrintStream(this.baos);
        }

        void purge() {
            try {
                this.ps.flush();
                this.baos.writeTo(ParallelPrintStream.this.base);
                this.baos.reset();
            }
            catch (IOException e) {
                ParallelPrintStream.this.setError();
            }
        }
    }
}

