/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.junit;

import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.kohsuke.junit.MethodCallRecorder;
import org.kohsuke.junit.ParallelPrintStream;
import org.kohsuke.junit.ThreadMarshaller;
import org.kohsuke.junit.WorkerThreadGroup;

public class ParallelTestSuite
extends TestSuite {
    private ParallelPrintStream out;
    private ParallelPrintStream err;
    private int nThreads;
    private ThreadMarshaller tm;
    private int nextTestIndex;
    static /* synthetic */ Class class$junit$framework$TestListener;

    public ParallelTestSuite(int nThreads) {
        this.nThreads = nThreads;
    }

    public ParallelTestSuite(Class theClass, String name, int nThreads) {
        super(theClass, name);
        this.nThreads = nThreads;
    }

    public ParallelTestSuite(Class theClass, int nThreads) {
        super(theClass);
        this.nThreads = nThreads;
    }

    public ParallelTestSuite(String name, int nThreads) {
        super(name);
        this.nThreads = nThreads;
    }

    public ParallelTestSuite() {
        this(ParallelTestSuite.defaultThreadSize());
    }

    public ParallelTestSuite(Class theClass, String name) {
        this(theClass, name, ParallelTestSuite.defaultThreadSize());
    }

    public ParallelTestSuite(Class theClass) {
        this(theClass, ParallelTestSuite.defaultThreadSize());
    }

    public ParallelTestSuite(String name) {
        this(name, ParallelTestSuite.defaultThreadSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(final TestResult result) {
        this.out = new ParallelPrintStream(System.out);
        System.setOut(this.out);
        this.err = new ParallelPrintStream(System.err);
        System.setErr(this.err);
        try {
            this.tm = new ThreadMarshaller(class$junit$framework$TestListener == null ? (class$junit$framework$TestListener = ParallelTestSuite.class$("junit.framework.TestListener")) : class$junit$framework$TestListener, (Object)new TestListener(){

                public void addError(Test test, Throwable t) {
                    result.addError(test, t);
                }

                public void addFailure(Test test, AssertionFailedError t) {
                    result.addFailure(test, t);
                }

                public void startTest(Test test) {
                    result.startTest(test);
                }

                public void endTest(Test test) {
                    result.endTest(test);
                }
            });
            ParallelTestSuite parallelTestSuite = this;
            synchronized (parallelTestSuite) {
                for (int i = 0; i < this.nThreads; ++i) {
                    new WorkerThread(i, (TestListener)this.tm.getProxy()).start();
                }
            }
            this.tm.run();
        }
        finally {
            System.setOut(this.out.getBase());
            System.setErr(this.err.getBase());
            this.out = null;
            this.err = null;
            this.tm = null;
        }
    }

    private synchronized Test getNextTest() {
        if (this.nextTestIndex == this.testCount()) {
            return null;
        }
        return this.testAt(this.nextTestIndex++);
    }

    private synchronized void finish() {
        --this.nThreads;
        if (this.nThreads == 0) {
            this.tm.finish();
        }
    }

    private static final int defaultThreadSize() {
        return 4;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    final class WorkerThread
    extends Thread {
        private final TestResult result;

        WorkerThread(int id, TestListener listener) {
            super((ThreadGroup)new WorkerThreadGroup(id), "WorkerThread-" + id);
            this.result = new ProxyTestResult(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Test t;
                while ((t = ParallelTestSuite.this.getNextTest()) != null) {
                    t.run(this.result);
                }
            }
            finally {
                ParallelTestSuite.this.finish();
            }
        }

        final class ProxyTestResult
        extends TestResult {
            private final MethodCallRecorder recorder = new MethodCallRecorder(class$junit$framework$TestListener == null ? (class$junit$framework$TestListener = ParallelTestSuite.class$("junit.framework.TestListener")) : class$junit$framework$TestListener);
            private final TestListener core;
            private TestListener recorderProxy = (TestListener)this.recorder.getProxy();

            public ProxyTestResult(TestListener core) {
                this.core = core;
            }

            public synchronized void addError(Test test, Throwable t) {
                super.addError(test, t);
                this.recorderProxy.addError(test, t);
            }

            public synchronized void addFailure(Test test, AssertionFailedError t) {
                super.addFailure(test, t);
                this.recorderProxy.addFailure(test, t);
            }

            public void startTest(Test test) {
                super.startTest(test);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void endTest(Test test) {
                super.endTest(test);
                ParallelTestSuite parallelTestSuite = ParallelTestSuite.this;
                synchronized (parallelTestSuite) {
                    this.core.startTest(test);
                    ParallelTestSuite.this.out.purge();
                    ParallelTestSuite.this.err.purge();
                    try {
                        this.recorder.replay(this.core);
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw new InternalError();
                    }
                    this.recorder.clear();
                    this.core.endTest(test);
                }
            }
        }
    }
}

