/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.tools.apt.Main;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.javac.JavacCompiler;
import org.kohsuke.stapler.AnnotationProcessorFactoryImpl;

public class AptCompiler
extends JavacCompiler {
    public List compile(CompilerConfiguration config) throws CompilerException {
        String[] sourceFiles;
        config.setTargetVersion("1.5");
        config.setSourceVersion("1.5");
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = AptCompiler.getSourceFiles((CompilerConfiguration)config)).length == 0) {
            return Collections.EMPTY_LIST;
        }
        this.getLogger().info("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        config.addCompilerCustomArgument("-s", new File(config.getOutputLocation()).getAbsolutePath());
        String[] args = AptCompiler.buildCompilerArguments((CompilerConfiguration)config, (String[])sourceFiles);
        return this.compileInProcess(args);
    }

    protected List compileInProcess(String[] args) throws CompilerException {
        Main aptTool = new Main();
        int r = Main.process((AnnotationProcessorFactory)new AnnotationProcessorFactoryImpl(), (PrintWriter)new PrintWriter(System.out, true), (String[])args);
        if (r != 0) {
            throw new CompilerException("APT failed: " + r);
        }
        return Collections.emptyList();
    }
}

