/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class StaplerMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File classesDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            JavaDocBuilder builder = new JavaDocBuilder();
            for (Object o : this.project.getCompileSourceRoots()) {
                builder.addSourceTree(new File((String)o));
            }
            for (JavaSource js : builder.getSources()) {
                for (JavaClass jc : js.getClasses()) {
                    for (JavaMethod jm : jc.getMethods()) {
                        if (jm.getTagByName("stapler-constructor") == null) continue;
                        if (!jm.isConstructor()) {
                            throw new MojoExecutionException(jc.getFullyQualifiedName() + '#' + jm.getName() + " is not a constructor");
                        }
                        StringBuffer buf = new StringBuffer();
                        for (JavaParameter p : jm.getParameters()) {
                            if (buf.length() > 0) {
                                buf.append(',');
                            }
                            buf.append(p.getName());
                        }
                        File dst = new File(this.classesDirectory, jc.getFullyQualifiedName().replace('.', File.separatorChar) + ".stapler");
                        dst.getParentFile().mkdirs();
                        FileOutputStream os = new FileOutputStream(dst);
                        Properties p = new Properties();
                        p.put("constructor", buf.toString());
                        p.store(os, null);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to process @stapler-constructor", (Exception)e);
        }
    }
}

