/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import java.io.IOException;
import java.net.URL;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.groovy.GroovierJellyScript;
import org.kohsuke.stapler.jelly.groovy.SimpleTemplateParser;
import org.kohsuke.stapler.jelly.groovy.StaplerClosureScript;

public class GroovyClassLoaderTearOff {
    private final MetaClassLoader owner;
    private final GroovyClassLoader gcl;
    private final SimpleTemplateParser parser = new SimpleTemplateParser(){

        protected String printCommand() {
            return "output.write";
        }
    };

    public GroovyClassLoaderTearOff(MetaClassLoader owner) {
        this.owner = owner;
        this.gcl = this.createGroovyClassLoader();
    }

    private GroovyClassLoader createGroovyClassLoader() {
        CompilerConfiguration cc = new CompilerConfiguration();
        cc.setScriptBaseClass(StaplerClosureScript.class.getName());
        cc.setRecompileGroovySource(MetaClass.NO_CACHE);
        return new GroovyClassLoader(this.owner.loader, cc){

            public URL getResource(String name) {
                URL res;
                if (MetaClassLoader.debugLoader != null && (res = MetaClassLoader.debugLoader.loader.getResource(name)) != null) {
                    return res;
                }
                return super.getResource(name);
            }
        };
    }

    public GroovierJellyScript parse(URL script) throws IOException {
        GroovyCodeSource gcs = new GroovyCodeSource(script);
        gcs.setCachable(false);
        return new GroovierJellyScript(this.gcl.parseClass(gcs), script);
    }

    public GroovierJellyScript parseGSP(URL res) throws IOException, ClassNotFoundException {
        GroovyCodeSource gcs = new GroovyCodeSource(this.parser.parse(res), res.toExternalForm(), res.toExternalForm());
        gcs.setCachable(false);
        return new GroovierJellyScript(this.gcl.parseClass(gcs), res);
    }
}

