/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.groovy;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;

class SimpleTemplateParser {
    SimpleTemplateParser() {
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Not relevant in this situation.")
    protected String parse(URL res) throws IOException {
        return this.parse(new InputStreamReader(res.openStream(), "UTF-8"));
    }

    protected String parse(Reader reader) throws IOException {
        int c;
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
        StringWriter sw = new StringWriter();
        this.startScript(sw);
        while ((c = reader.read()) != -1) {
            if (c == 60) {
                reader.mark(1);
                c = reader.read();
                if (c != 37) {
                    sw.write(60);
                    reader.reset();
                    continue;
                }
                reader.mark(1);
                c = reader.read();
                if (c == 61) {
                    this.groovyExpression(reader, sw);
                    continue;
                }
                reader.reset();
                this.groovySection(reader, sw);
                continue;
            }
            if (c == 36) {
                reader.mark(1);
                c = reader.read();
                if (c != 123) {
                    sw.write(36);
                    reader.reset();
                    continue;
                }
                reader.mark(1);
                sw.write("${");
                this.processGSstring(reader, sw);
                continue;
            }
            if (c == 34) {
                sw.write(92);
            }
            if (c == 10 || c == 13) {
                if (c == 13) {
                    reader.mark(1);
                    c = reader.read();
                    if (c != 10) {
                        reader.reset();
                    }
                }
                sw.write("\n");
                continue;
            }
            sw.write(c);
        }
        this.endScript(sw);
        return sw.toString();
    }

    protected String printCommand() {
        return "out.print";
    }

    private void startScript(StringWriter sw) {
        sw.write(this.printCommand() + "(\"\"\"");
    }

    private void endScript(StringWriter sw) {
        sw.write("\"\"\");\n");
        sw.write("\n/* Generated by SimpleTemplateEngine */");
    }

    private void processGSstring(Reader reader, StringWriter sw) throws IOException {
        int c;
        while ((c = reader.read()) != -1) {
            if (c != 10 && c != 13) {
                sw.write(c);
            }
            if (c != 125) continue;
            break;
        }
    }

    private void groovyExpression(Reader reader, StringWriter sw) throws IOException {
        int c;
        sw.write("${");
        while ((c = reader.read()) != -1) {
            if (c == 37) {
                c = reader.read();
                if (c == 62) break;
                sw.write(37);
            }
            if (c == 10 || c == 13) continue;
            sw.write(c);
        }
        sw.write("}");
    }

    private void groovySection(Reader reader, StringWriter sw) throws IOException {
        int c;
        sw.write("\"\"\");");
        while ((c = reader.read()) != -1) {
            if (c == 37) {
                c = reader.read();
                if (c == 62) break;
                sw.write(37);
            }
            sw.write(c);
        }
        sw.write(";\n" + this.printCommand() + "(\"\"\"");
    }
}

