/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionSupport;
import org.apache.commons.jelly.impl.TagScript;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.CallTagLibScript;
import org.kohsuke.stapler.jelly.JellyClassTearOff;
import org.kohsuke.stapler.lang.Klass;
import org.xml.sax.Attributes;

public class ThisTagLibrary
extends TagLibrary {
    private final Expression expr;
    public static final ThisTagLibrary INSTANCE = new ThisTagLibrary((Expression)new ExpressionSupport(){

        public String getExpressionText() {
            return "it";
        }

        public Object evaluate(JellyContext context) {
            return context.getVariable("it");
        }
    });

    public ThisTagLibrary(Expression expr) {
        this.expr = expr;
    }

    public Tag createTag(String name, Attributes attributes) throws JellyException {
        return null;
    }

    public TagScript createTagScript(final String tagName, Attributes atts) throws JellyException {
        return new CallTagLibScript(){

            @Override
            protected Script resolveDefinition(JellyContext context) throws JellyTagException {
                Object it = ThisTagLibrary.this.expr.evaluate(context);
                if (it == null) {
                    throw new JellyTagException("'" + ThisTagLibrary.this.expr.getExpressionText() + "' evaluated to null");
                }
                try {
                    WebApp webApp = WebApp.getCurrent();
                    MetaClass c = webApp.getMetaClass(it instanceof Class ? Klass.java((Class)((Class)it)) : webApp.getKlass(it));
                    Script tag = (Script)((JellyClassTearOff)((Object)c.loadTearOff(JellyClassTearOff.class))).findScript(tagName + ".jellytag");
                    if (tag == null) {
                        tag = (Script)((JellyClassTearOff)((Object)c.loadTearOff(JellyClassTearOff.class))).findScript(tagName + ".jelly");
                    }
                    if (tag == null) {
                        throw new JellyTagException("No such tag file " + tagName + ".jellytag in " + c);
                    }
                    return tag;
                }
                catch (JellyException e) {
                    throw new JellyTagException("Failed to load " + tagName + ".jellytag from " + it, (Throwable)e);
                }
            }
        };
    }
}

