/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.JellyFacet;

public final class JellyRequestDispatcher
implements RequestDispatcher {
    private final Object it;
    private final Script script;
    private final JellyFacet facet;

    public JellyRequestDispatcher(Object it, Script script) {
        this.it = it;
        this.script = script;
        this.facet = (JellyFacet)WebApp.getCurrent().getFacet(JellyFacet.class);
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        try {
            this.facet.scriptInvoker.invokeScript((StaplerRequest)servletRequest, (StaplerResponse)servletResponse, this.script, this.it);
        }
        catch (JellyTagException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @SuppressFBWarnings(value={"REQUESTDISPATCHER_FILE_DISCLOSURE"}, justification="Forwarding the request to be handled correctly.")
    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.forward(servletRequest, servletResponse);
    }
}

