/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.failuredetect;

import java.io.Closeable;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.fluency.fluentd.ingester.sender.failuredetect.FailureDetectStrategy;
import org.komamitsu.fluency.fluentd.ingester.sender.heartbeat.Heartbeater;
import org.komamitsu.fluency.validation.Validatable;
import org.komamitsu.fluency.validation.annotation.Min;

public class FailureDetector
implements Heartbeater.Callback,
Closeable {
    private final FailureDetectStrategy failureDetectStrategy;
    private final Heartbeater heartbeater;
    private final AtomicReference<Long> lastFailureTimestampMillis = new AtomicReference();
    private final Config config;

    public FailureDetector(FailureDetectStrategy failureDetectStrategy, Heartbeater heartbeater, Config config) {
        config.validateValues();
        this.failureDetectStrategy = failureDetectStrategy;
        this.heartbeater = heartbeater;
        this.heartbeater.setCallback(this);
        this.heartbeater.start();
        this.config = config;
    }

    public FailureDetector(FailureDetectStrategy failureDetectStrategy, Heartbeater heartbeater) {
        this(failureDetectStrategy, heartbeater, new Config());
    }

    @Override
    public void onHeartbeat() {
        this.failureDetectStrategy.heartbeat(System.currentTimeMillis());
    }

    @Override
    public void onFailure(Throwable cause) {
        this.lastFailureTimestampMillis.set(System.currentTimeMillis());
    }

    public boolean isAvailable() {
        Long failureTimestamp = this.lastFailureTimestampMillis.get();
        if (failureTimestamp != null) {
            if (failureTimestamp > System.currentTimeMillis() - (long)this.config.getFailureIntervalMillis()) {
                return false;
            }
            this.lastFailureTimestampMillis.set(null);
        }
        return this.failureDetectStrategy.isAvailable();
    }

    @Override
    public void close() {
        this.heartbeater.close();
    }

    public FailureDetectStrategy getFailureDetectStrategy() {
        return this.failureDetectStrategy;
    }

    public Heartbeater getHeartbeater() {
        return this.heartbeater;
    }

    public int getFailureIntervalMillis() {
        return this.config.getFailureIntervalMillis();
    }

    public String toString() {
        return "FailureDetector{failureDetectStrategy=" + this.failureDetectStrategy + ", heartbeater=" + this.heartbeater + ", lastFailureTimestampMillis=" + this.lastFailureTimestampMillis + ", config=" + this.config + '}';
    }

    public static class Config
    implements Validatable {
        @Min(value=0L)
        private int failureIntervalMillis = 3000;

        public int getFailureIntervalMillis() {
            return this.failureIntervalMillis;
        }

        public void setFailureIntervalMillis(int failureIntervalMillis) {
            this.failureIntervalMillis = failureIntervalMillis;
        }

        void validateValues() {
            this.validate();
        }

        public String toString() {
            return "Config{failureIntervalMillis=" + this.failureIntervalMillis + '}';
        }
    }
}

