/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.retry;

import org.komamitsu.fluency.fluentd.ingester.sender.retry.RetryStrategy;
import org.komamitsu.fluency.validation.Validatable;
import org.komamitsu.fluency.validation.annotation.Min;

public class ExponentialBackOffRetryStrategy
extends RetryStrategy {
    private final Config config;

    public ExponentialBackOffRetryStrategy() {
        this(new Config());
    }

    public ExponentialBackOffRetryStrategy(Config config) {
        super(config);
        config.validateValues();
        this.config = config;
    }

    @Override
    public int getNextIntervalMillis(int retryCount) {
        int interval = this.config.getBaseIntervalMillis() * (int)Math.pow(2.0, retryCount);
        if (interval > this.config.getMaxIntervalMillis()) {
            return this.config.getMaxIntervalMillis();
        }
        return interval;
    }

    public int getBaseIntervalMillis() {
        return this.config.getBaseIntervalMillis();
    }

    public int getMaxIntervalMillis() {
        return this.config.getMaxIntervalMillis();
    }

    @Override
    public String toString() {
        return "ExponentialBackOffRetryStrategy{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    extends RetryStrategy.Config
    implements Validatable {
        @Min(value=10L)
        private int baseIntervalMillis = 400;
        @Min(value=10L)
        private int maxIntervalMillis = 30000;

        public int getBaseIntervalMillis() {
            return this.baseIntervalMillis;
        }

        public void setBaseIntervalMillis(int baseIntervalMillis) {
            this.baseIntervalMillis = baseIntervalMillis;
        }

        public int getMaxIntervalMillis() {
            return this.maxIntervalMillis;
        }

        public void setMaxIntervalMillis(int maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
        }

        void validateValues() {
            this.validate();
        }

        @Override
        public String toString() {
            return "Config{baseIntervalMillis=" + this.baseIntervalMillis + ", maxIntervalMillis=" + this.maxIntervalMillis + "} " + super.toString();
        }
    }
}

