/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.komamitsu.fluency.fluentd.ingester.sender.FluentdSender;
import org.komamitsu.fluency.fluentd.ingester.sender.retry.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableSender
extends FluentdSender {
    private static final Logger LOG = LoggerFactory.getLogger(RetryableSender.class);
    private final FluentdSender baseSender;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private RetryStrategy retryStrategy;

    public RetryableSender(FluentdSender baseSender, RetryStrategy retryStrategy) {
        this(new Config(), baseSender, retryStrategy);
    }

    public RetryableSender(Config config, FluentdSender baseSender, RetryStrategy retryStrategy) {
        super(config);
        this.baseSender = baseSender;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public void close() throws IOException {
        this.baseSender.close();
        this.isClosed.set(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected synchronized void sendInternal(List<ByteBuffer> buffers, String ackToken) throws IOException {
        IOException firstException = null;
        int retry = 0;
        while (!this.retryStrategy.isRetriedOver(retry)) {
            if (this.isClosed.get()) {
                throw new RetryOverException("This sender is already closed", firstException);
            }
            try {
                if (ackToken == null) {
                    this.baseSender.send(buffers);
                } else {
                    this.baseSender.sendWithAck(buffers, ackToken);
                }
                return;
            }
            catch (IOException e) {
                firstException = e;
                LOG.warn("Sender failed to send data. sender=" + this + ", retry=" + retry, (Throwable)e);
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryStrategy.getNextIntervalMillis(retry));
                }
                catch (InterruptedException e2) {
                    LOG.debug("Interrupted while waiting", (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
                ++retry;
            }
        }
        throw new RetryOverException("Sending data was retried over", firstException);
    }

    public FluentdSender getBaseSender() {
        return this.baseSender;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public String toString() {
        return "RetryableSender{baseSender=" + this.baseSender + ", retryStrategy=" + this.retryStrategy + ", isClosed=" + this.isClosed + "} " + super.toString();
    }

    public static class Config
    extends FluentdSender.Config {
    }

    public static class RetryOverException
    extends IOException {
        public RetryOverException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

