/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SSLSocketBuilder {
    private final String host;
    private final int port;
    private final int connectionTimeoutMilli;
    private final int readTimeoutMilli;
    private final SSLSocketFactory sslSocketFactory;

    public SSLSocketBuilder(String host, Integer port, int connectionTimeoutMilli, int readTimeoutMilli, SocketFactory sslSocketFactory) {
        this.host = host;
        this.port = port;
        this.connectionTimeoutMilli = connectionTimeoutMilli;
        this.readTimeoutMilli = readTimeoutMilli;
        this.sslSocketFactory = (SSLSocketFactory)sslSocketFactory;
    }

    public SSLSocket build() throws IOException {
        Socket socket = this.sslSocketFactory.createSocket();
        try {
            socket.connect(new InetSocketAddress(this.host, this.port), this.connectionTimeoutMilli);
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(this.readTimeoutMilli);
        }
        catch (Throwable e) {
            socket.close();
            throw e;
        }
        return (SSLSocket)socket;
    }

    public String toString() {
        return "SSLSocketBuilder{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

