/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.heartbeat;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.komamitsu.fluency.fluentd.ingester.sender.heartbeat.InetSocketHeartbeater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPHeartbeater
extends InetSocketHeartbeater {
    private static final Logger LOG = LoggerFactory.getLogger(TCPHeartbeater.class);
    private final Config config;

    public TCPHeartbeater() {
        this(new Config());
    }

    public TCPHeartbeater(Config config) {
        super(config);
        this.config = config;
    }

    @Override
    protected void invoke() throws IOException {
        try (SocketChannel socketChannel = SocketChannel.open(new InetSocketAddress(this.config.getHost(), this.config.getPort()));){
            LOG.trace("TCPHeartbeat: remotePort={}, localPort={}", (Object)socketChannel.socket().getPort(), (Object)socketChannel.socket().getLocalPort());
            this.pong();
        }
    }

    @Override
    public String toString() {
        return "TCPHeartbeater{config=" + this.config + "} " + super.toString();
    }

    public static class Config
    extends InetSocketHeartbeater.Config {
    }
}

