/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.heartbeat;

import java.io.IOException;
import org.komamitsu.fluency.fluentd.ingester.sender.heartbeat.Heartbeater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InetSocketHeartbeater
extends Heartbeater {
    private static final Logger LOG = LoggerFactory.getLogger(InetSocketHeartbeater.class);
    private final Config config;

    protected InetSocketHeartbeater(Config config) {
        super(config);
        this.config = config;
    }

    @Override
    protected abstract void invoke() throws IOException;

    public String getHost() {
        return this.config.getHost();
    }

    public int getPort() {
        return this.config.getPort();
    }

    @Override
    public int getIntervalMillis() {
        return this.config.getIntervalMillis();
    }

    @Override
    public String toString() {
        return "InetHeartbeater{config=" + this.config + '}';
    }

    public static class Config
    extends Heartbeater.Config {
        private String host = "127.0.0.1";
        private int port = 24224;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        @Override
        public String toString() {
            return "Config{host='" + this.host + '\'' + ", port=" + this.port + "} " + super.toString();
        }
    }

    public static interface Callback {
        public void onHeartbeat();

        public void onFailure(Throwable var1);
    }
}

