/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.heartbeat;

import java.io.IOException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.komamitsu.fluency.fluentd.ingester.sender.SSLSocketBuilder;
import org.komamitsu.fluency.fluentd.ingester.sender.heartbeat.InetSocketHeartbeater;
import org.komamitsu.fluency.validation.Validatable;
import org.komamitsu.fluency.validation.annotation.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLHeartbeater
extends InetSocketHeartbeater {
    private static final Logger LOG = LoggerFactory.getLogger(SSLHeartbeater.class);
    private final Config config;
    private final SSLSocketBuilder sslSocketBuilder;

    public SSLHeartbeater() {
        this(new Config());
    }

    public SSLHeartbeater(Config config) {
        super(config);
        config.validateValues();
        this.config = config;
        this.sslSocketBuilder = new SSLSocketBuilder(config.getHost(), config.getPort(), config.connectionTimeoutMilli, config.readTimeoutMilli, config.getSslSocketFactory());
    }

    @Override
    protected void invoke() throws IOException {
        try (SSLSocket sslSocket = this.sslSocketBuilder.build();){
            LOG.trace("SSLHeartbeat: remotePort={}, localPort={}", (Object)sslSocket.getPort(), (Object)sslSocket.getLocalPort());
            sslSocket.getSession();
            this.pong();
        }
    }

    @Override
    public String toString() {
        return "SSLHeartbeater{config=" + this.config + ", sslSocketBuilder=" + this.sslSocketBuilder + "} " + super.toString();
    }

    public static class Config
    extends InetSocketHeartbeater.Config
    implements Validatable {
        @Min(value=10L)
        private int connectionTimeoutMilli = 5000;
        @Min(value=10L)
        private int readTimeoutMilli = 5000;
        private SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

        public int getConnectionTimeoutMilli() {
            return this.connectionTimeoutMilli;
        }

        public void setConnectionTimeoutMilli(int connectionTimeoutMilli) {
            this.connectionTimeoutMilli = connectionTimeoutMilli;
        }

        public int getReadTimeoutMilli() {
            return this.readTimeoutMilli;
        }

        public void setReadTimeoutMilli(int readTimeoutMilli) {
            this.readTimeoutMilli = readTimeoutMilli;
        }

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }

        @Override
        void validateValues() {
            this.validate();
        }
    }
}

