/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.komamitsu.fluency.fluentd.ingester.Response;
import org.komamitsu.fluency.fluentd.ingester.sender.FluentdSender;
import org.komamitsu.fluency.fluentd.ingester.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.util.ExecutorServiceUtils;
import org.komamitsu.fluency.validation.annotation.Min;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetworkSender<T>
extends FluentdSender {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkSender.class);
    private final byte[] optionBuffer = new byte[256];
    private final ExecutorService executorService = ExecutorServiceUtils.newSingleThreadDaemonExecutor();
    private final Config config;
    private final FailureDetector failureDetector;
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());

    NetworkSender(FailureDetector failureDetector) {
        this(new Config(), failureDetector);
    }

    NetworkSender(Config config, FailureDetector failureDetector) {
        super(config);
        this.config = config;
        this.failureDetector = failureDetector;
    }

    @Override
    public boolean isAvailable() {
        return this.failureDetector == null || this.failureDetector.isAvailable();
    }

    abstract T getOrCreateSocketInternal() throws IOException;

    private synchronized T getOrCreateSocket() throws IOException {
        return this.getOrCreateSocketInternal();
    }

    abstract void sendBuffers(T var1, List<ByteBuffer> var2) throws IOException;

    abstract void recvResponse(T var1, ByteBuffer var2) throws IOException;

    private void propagateFailure(Throwable e) {
        if (this.failureDetector != null) {
            this.failureDetector.onFailure(e);
        }
    }

    @Override
    protected synchronized void sendInternal(List<ByteBuffer> buffers, String ackToken) throws IOException {
        long totalDataSize = buffers.stream().mapToInt(Buffer::remaining).sum();
        try {
            LOG.trace("send(): sender={}, totalDataSize={}", (Object)this, (Object)totalDataSize);
            T socket = this.getOrCreateSocket();
            this.sendBuffers(socket, buffers);
            if (ackToken == null) {
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.optionBuffer);
            Future<Void> future = this.executorService.submit(() -> {
                LOG.trace("recv(): sender={}", (Object)this);
                this.recvResponse(socket, byteBuffer);
                return null;
            });
            try {
                future.get(this.config.getReadTimeoutMilli(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new IOException("InterruptedException occurred", e);
            }
            catch (ExecutionException e) {
                throw new IOException("ExecutionException occurred", e);
            }
            catch (TimeoutException e) {
                throw new SocketTimeoutException("Socket read timeout");
            }
            Response response = (Response)this.objectMapper.readValue(this.optionBuffer, Response.class);
            if (!ackToken.equals(response.getAck())) {
                throw new UnmatchedAckException("Ack tokens don't matched: expected=, got=" + response.getAck());
            }
        }
        catch (IOException e) {
            LOG.error("Failed to send {} bytes data", (Object)totalDataSize);
            this.closeSocket();
            this.propagateFailure(e);
            throw e;
        }
    }

    abstract void closeSocket() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        try {
            try {
                TimeUnit.MILLISECONDS.sleep(this.config.getWaitBeforeCloseMilli());
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.closeSocket();
        }
        finally {
            try {
                if (this.failureDetector != null) {
                    this.failureDetector.close();
                }
            }
            finally {
                ExecutorServiceUtils.finishExecutorService((ExecutorService)this.executorService);
            }
        }
    }

    public int getConnectionTimeoutMilli() {
        return this.config.getConnectionTimeoutMilli();
    }

    public int getReadTimeoutMilli() {
        return this.config.getReadTimeoutMilli();
    }

    public FailureDetector getFailureDetector() {
        return this.failureDetector;
    }

    public String toString() {
        return "NetworkSender{config=" + (Object)((Object)this.config) + ", failureDetector=" + this.failureDetector + "} " + super.toString();
    }

    public static class Config
    extends FluentdSender.Config {
        @Min(value=10L)
        private int connectionTimeoutMilli = 5000;
        @Min(value=10L)
        private int readTimeoutMilli = 5000;
        @Min(value=0L)
        private int waitBeforeCloseMilli = 1000;

        public int getConnectionTimeoutMilli() {
            return this.connectionTimeoutMilli;
        }

        public void setConnectionTimeoutMilli(int connectionTimeoutMilli) {
            this.connectionTimeoutMilli = connectionTimeoutMilli;
        }

        public int getReadTimeoutMilli() {
            return this.readTimeoutMilli;
        }

        public void setReadTimeoutMilli(int readTimeoutMilli) {
            this.readTimeoutMilli = readTimeoutMilli;
        }

        public int getWaitBeforeCloseMilli() {
            return this.waitBeforeCloseMilli;
        }

        public void setWaitBeforeCloseMilli(int waitBeforeCloseMilli) {
            this.waitBeforeCloseMilli = waitBeforeCloseMilli;
        }

        public String toString() {
            return "Config{connectionTimeoutMilli=" + this.connectionTimeoutMilli + ", readTimeoutMilli=" + this.readTimeoutMilli + ", waitBeforeCloseMilli=" + this.waitBeforeCloseMilli + "} " + super.toString();
        }
    }

    public static class UnmatchedAckException
    extends IOException {
        public UnmatchedAckException(String message) {
            super(message);
        }
    }
}

