/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.komamitsu.fluency.fluentd.ingester.sender.InetSocketSender;
import org.komamitsu.fluency.fluentd.ingester.sender.SSLSocketBuilder;
import org.komamitsu.fluency.fluentd.ingester.sender.TCPSender;
import org.komamitsu.fluency.fluentd.ingester.sender.failuredetect.FailureDetector;
import org.komamitsu.fluency.validation.Validatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSender
extends InetSocketSender<SSLSocket> {
    private static final Logger LOG = LoggerFactory.getLogger(TCPSender.class);
    private final AtomicReference<SSLSocket> socket = new AtomicReference();
    private final SSLSocketBuilder socketBuilder;
    private final Config config;

    public SSLSender() {
        this(new Config());
    }

    public SSLSender(Config config) {
        this(config, null);
    }

    public SSLSender(FailureDetector failureDetector) {
        this(new Config(), failureDetector);
    }

    public SSLSender(Config config, FailureDetector failureDetector) {
        super(config, failureDetector);
        config.validateValues();
        this.socketBuilder = new SSLSocketBuilder(config.getHost(), config.getPort(), config.getConnectionTimeoutMilli(), config.getReadTimeoutMilli(), config.getSslSocketFactory());
        this.config = config;
    }

    @Override
    protected SSLSocket getOrCreateSocketInternal() throws IOException {
        if (this.socket.get() == null) {
            this.socket.set(this.socketBuilder.build());
        }
        return this.socket.get();
    }

    @Override
    protected void sendBuffers(SSLSocket sslSocket, List<ByteBuffer> buffers) throws IOException {
        for (ByteBuffer buffer : buffers) {
            OutputStream outputStream = sslSocket.getOutputStream();
            if (buffer.hasArray()) {
                outputStream.write(buffer.array(), buffer.position(), buffer.remaining());
                continue;
            }
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            outputStream.write(bytes);
        }
    }

    @Override
    protected void recvResponse(SSLSocket sslSocket, ByteBuffer buffer) throws IOException {
        byte[] tempBuf;
        InputStream inputStream = sslSocket.getInputStream();
        int read = inputStream.read(tempBuf = new byte[buffer.remaining()]);
        if (read < 0) {
            throw new SocketException("The connection is disconnected by the peer");
        }
        buffer.put(tempBuf, 0, read);
    }

    @Override
    protected void closeSocket() throws IOException {
        SSLSocket existingSocket = this.socket.getAndSet(null);
        if (existingSocket != null) {
            existingSocket.close();
        }
    }

    @Override
    public String toString() {
        return "SSLSender{config=" + (Object)((Object)this.config) + "} " + super.toString();
    }

    public static class Config
    extends InetSocketSender.Config
    implements Validatable {
        private SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();

        void validateValues() {
            this.validate();
        }

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }
    }
}

