/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.spring.data.sqlite;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Optional;
import org.komamitsu.spring.data.sqlite.SqliteDialect;
import org.springframework.data.jdbc.repository.config.DialectResolver;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.jdbc.core.JdbcOperations;

public class SqliteDialectProvider
implements DialectResolver.JdbcDialectProvider {
    public Optional<Dialect> getDialect(JdbcOperations operations) {
        Optional<Dialect> dialect = Optional.ofNullable((Dialect)operations.execute(SqliteDialectProvider::getDialect));
        if (dialect.isPresent()) {
            return dialect;
        }
        return new DialectResolver.DefaultDialectProvider().getDialect(operations);
    }

    private static Dialect getDialect(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String name = metaData.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
        if (name.contains("sqlite")) {
            return SqliteDialect.INSTANCE;
        }
        return null;
    }
}

