/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.spring.data.sqlite;

import org.komamitsu.spring.data.sqlite.SqliteJdbcAggregateTemplate;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.support.JdbcRepositoryFactory;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;

public class SqliteJdbcRepositoryFactory
extends JdbcRepositoryFactory {
    private final ApplicationEventPublisher publisher;
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final DataAccessStrategy accessStrategy;
    private EntityCallbacks entityCallbacks;

    public SqliteJdbcRepositoryFactory(DataAccessStrategy dataAccessStrategy, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, ApplicationEventPublisher publisher, NamedParameterJdbcOperations operations) {
        super(dataAccessStrategy, context, converter, dialect, publisher, operations);
        this.publisher = publisher;
        this.context = context;
        this.converter = converter;
        this.accessStrategy = dataAccessStrategy;
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        SqliteJdbcAggregateTemplate template = new SqliteJdbcAggregateTemplate(this.publisher, this.context, this.converter, this.accessStrategy);
        if (this.entityCallbacks != null) {
            template.setEntityCallbacks(this.entityCallbacks);
        }
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(repositoryInformation.getDomainType());
        return this.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{template, persistentEntity, this.converter});
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        this.entityCallbacks = entityCallbacks;
        super.setEntityCallbacks(entityCallbacks);
    }
}

