/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.codegen;

import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.codegen.ClassResolver;
import org.komapper.codegen.CodeGenerator;
import org.komapper.core.SnakeToLowerCamelCase;
import org.komapper.core.SnakeToUpperCamelCase;
import org.komapper.jdbc.dsl.query.MetadataQuery;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0005H\u0002J.\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0012J,\u0010\u0015\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/komapper/codegen/CodeGenerator;", "", "destinationDir", "Ljava/nio/file/Path;", "packageName", "", "prefix", "suffix", "tables", "", "Lorg/komapper/jdbc/dsl/query/MetadataQuery$Table;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "createFilePath", "name", "generateDefinitions", "", "fileName", "overwrite", "", "useCatalog", "useSchema", "generateEntities", "declareAsNullable", "resolver", "Lorg/komapper/codegen/ClassResolver;", "mkdirs", "dir", "komapper-codegen"})
public final class CodeGenerator {
    @NotNull
    private final Path destinationDir;
    @Nullable
    private final String packageName;
    @NotNull
    private final String prefix;
    @NotNull
    private final String suffix;
    @NotNull
    private final List<MetadataQuery.Table> tables;

    public CodeGenerator(@NotNull Path destinationDir, @Nullable String packageName, @NotNull String prefix, @NotNull String suffix, @NotNull List<MetadataQuery.Table> tables) {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        this.destinationDir = destinationDir;
        this.packageName = packageName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.tables = tables;
    }

    public /* synthetic */ CodeGenerator(Path path, String string, String string2, String string3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        this(path, string, string2, string3, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateEntities(@NotNull String fileName, boolean overwrite, boolean declareAsNullable, @NotNull ClassResolver resolver) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Path file = this.createFilePath(fileName);
        if (Files.exists(file, new LinkOption[0]) && !overwrite) {
            return;
        }
        Object object = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.parent");
        this.mkdirs((Path)object);
        object = file;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        object = new PrintWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset));
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            PrintWriter p = (PrintWriter)object;
            boolean bl4 = false;
            if (this.packageName != null) {
                p.println(Intrinsics.stringPlus((String)"package ", (Object)this.packageName));
            }
            for (MetadataQuery.Table table : this.tables) {
                p.println();
                String className = SnakeToUpperCamelCase.INSTANCE.apply(table.getName());
                p.println("data class " + this.prefix + className + this.suffix + " (");
                for (MetadataQuery.Column column : table.getColumns()) {
                    String propertyName = SnakeToLowerCamelCase.INSTANCE.apply(column.getName());
                    String nullable = declareAsNullable || column.getNullable() ? "?" : "";
                    KClass kClass = resolver.resolve(column);
                    KClass klass = kClass == null ? Reflection.getOrCreateKotlinClass(String.class) : kClass;
                    String string = klass.getQualifiedName();
                    String propertyClassName = Intrinsics.areEqual((Object)(string == null ? null : StringsKt.removePrefix((String)string, (CharSequence)"kotlin.")), (Object)klass.getSimpleName()) ? klass.getSimpleName() : klass.getQualifiedName();
                    p.println("    val " + propertyName + ": " + propertyClassName + nullable + ',');
                }
                p.println(")");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void generateEntities$default(CodeGenerator codeGenerator, String string, boolean bl, boolean bl2, ClassResolver classResolver, int n, Object object) {
        if ((n & 1) != 0) {
            string = "entities.kt";
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        codeGenerator.generateEntities(string, bl, bl2, classResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateDefinitions(@NotNull String fileName, boolean overwrite, boolean useCatalog, boolean useSchema) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Path file = this.createFilePath(fileName);
        if (Files.exists(file, new LinkOption[0]) && !overwrite) {
            return;
        }
        Object object = file.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"file.parent");
        this.mkdirs((Path)object);
        object = file;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        object = new PrintWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset));
        boolean bl2 = false;
        boolean bl3 = false;
        Throwable throwable = null;
        try {
            PrintWriter p = (PrintWriter)object;
            boolean bl4 = false;
            if (this.packageName != null) {
                p.println(Intrinsics.stringPlus((String)"package ", (Object)this.packageName));
                p.println();
            }
            p.println("import org.komapper.annotation.*");
            for (MetadataQuery.Table table : this.tables) {
                p.println();
                String className = SnakeToUpperCamelCase.INSTANCE.apply(table.getName());
                p.println("@KomapperEntityDef(" + className + "::class)");
                String[] stringArray = new String[]{table.getName(), useCatalog ? table.getCatalog() : null, useSchema ? table.getSchema() : null};
                String kmTableArgs2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])stringArray), null, null, null, (int)0, null, (Function1)generateDefinitions.1.kmTableArgs.1.INSTANCE, (int)31, null);
                p.println("@KomapperTable(" + kmTableArgs2 + ')');
                p.println("data class " + this.prefix + className + this.suffix + "Def (");
                for (MetadataQuery.Column column : table.getColumns()) {
                    String propertyName = SnakeToLowerCamelCase.INSTANCE.apply(column.getName());
                    String id = column.isPrimaryKey() ? "@KomapperId " : "";
                    String autoIncrement = column.isAutoIncrement() ? "@KomapperAutoIncrement " : "";
                    p.println("    " + id + autoIncrement + "@KomapperColumn(\"" + column.getName() + "\") val " + propertyName + ": Nothing,");
                }
                p.println(")");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void generateDefinitions$default(CodeGenerator codeGenerator, String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            string = "entityDefinitions.kt";
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        codeGenerator.generateDefinitions(string, bl, bl2, bl3);
    }

    private final Path createFilePath(String name) {
        Path path;
        if (this.packageName == null) {
            path = this.destinationDir;
        } else {
            String path2 = StringsKt.replace$default((String)this.packageName, (String)".", (String)"/", (boolean)false, (int)4, null);
            path = this.destinationDir.resolve(path2);
        }
        Path packageDir = path;
        Path path3 = packageDir.resolve(name);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"packageDir.resolve(name)");
        return path3;
    }

    private final void mkdirs(Path dir) {
        Files.createDirectories(dir, new FileAttribute[0]);
    }
}

