/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.codegen;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.komapper.codegen.Enquote;

class EnquoteImpl
implements Enquote {
    private static final Pattern JDBC_URL_PATTERN = Pattern.compile("^jdbc:(tc:)?([^:]*):.*");
    private final String driver;

    EnquoteImpl(String url) {
        this.driver = EnquoteImpl.extractDriver(url);
    }

    private static String extractDriver(String url) {
        Matcher matcher = JDBC_URL_PATTERN.matcher(url);
        if (matcher.matches()) {
            return matcher.group(2).toLowerCase();
        }
        throw new IllegalArgumentException("The driver in the JDBC URL is not found. url=" + url);
    }

    @Override
    @NotNull
    public String apply(@NotNull String identifier) {
        Objects.requireNonNull(identifier);
        switch (this.driver) {
            case "mysql": 
            case "mariadb": {
                return "`" + identifier + "`";
            }
            case "sqlserver": {
                return "[" + identifier + "]";
            }
        }
        return "\"" + identifier + "\"";
    }
}

