/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.codegen;

import java.sql.JDBCType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.komapper.codegen.Column;
import org.komapper.codegen.PropertyTypeResolverImpl;
import org.komapper.codegen.Table;

public interface PropertyTypeResolver {
    @NotNull
    public String resolve(@NotNull Table var1, @NotNull Column var2);

    @NotNull
    public static PropertyTypeResolver of() {
        return new PropertyTypeResolverImpl(PropertyTypeResolver.createDataTypeMap());
    }

    @NotNull
    public static PropertyTypeResolver of(@NotNull Map<Integer, String> dataTypeMap) {
        HashMap<Integer, String> newDataTypeMap = new HashMap<Integer, String>(PropertyTypeResolver.createDataTypeMap());
        newDataTypeMap.putAll(dataTypeMap);
        return new PropertyTypeResolverImpl(newDataTypeMap);
    }

    private static Map<Integer, String> createDataTypeMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>(JDBCType.values().length);
        map.put(JDBCType.ARRAY.getVendorTypeNumber(), "java.sql.Array");
        map.put(JDBCType.BIGINT.getVendorTypeNumber(), "Long");
        map.put(JDBCType.BINARY.getVendorTypeNumber(), "ByteArray");
        map.put(JDBCType.BIT.getVendorTypeNumber(), "Boolean");
        map.put(JDBCType.BLOB.getVendorTypeNumber(), "java.sql.Blob");
        map.put(JDBCType.BOOLEAN.getVendorTypeNumber(), "Boolean");
        map.put(JDBCType.CHAR.getVendorTypeNumber(), "String");
        map.put(JDBCType.CLOB.getVendorTypeNumber(), "java.sql.Clob");
        map.put(JDBCType.DATE.getVendorTypeNumber(), "java.time.LocalDate");
        map.put(JDBCType.DECIMAL.getVendorTypeNumber(), "java.math.BigDecimal");
        map.put(JDBCType.DOUBLE.getVendorTypeNumber(), "Double");
        map.put(JDBCType.FLOAT.getVendorTypeNumber(), "Double");
        map.put(JDBCType.INTEGER.getVendorTypeNumber(), "Int");
        map.put(JDBCType.LONGNVARCHAR.getVendorTypeNumber(), "String");
        map.put(JDBCType.LONGVARBINARY.getVendorTypeNumber(), "ByteArray");
        map.put(JDBCType.LONGVARCHAR.getVendorTypeNumber(), "String");
        map.put(JDBCType.NCHAR.getVendorTypeNumber(), "String");
        map.put(JDBCType.NCLOB.getVendorTypeNumber(), "java.sql.NClob");
        map.put(JDBCType.NUMERIC.getVendorTypeNumber(), "java.math.BigDecimal");
        map.put(JDBCType.NVARCHAR.getVendorTypeNumber(), "String");
        map.put(JDBCType.REAL.getVendorTypeNumber(), "Double");
        map.put(JDBCType.SMALLINT.getVendorTypeNumber(), "Int");
        map.put(JDBCType.SQLXML.getVendorTypeNumber(), "java.sql.SQLXML");
        map.put(JDBCType.TIME.getVendorTypeNumber(), "java.time.LocalTime");
        map.put(JDBCType.TIMESTAMP.getVendorTypeNumber(), "java.time.LocalDateTime");
        map.put(JDBCType.TIMESTAMP_WITH_TIMEZONE.getVendorTypeNumber(), "java.time.OffsetDateTime");
        map.put(JDBCType.TINYINT.getVendorTypeNumber(), "Int");
        map.put(JDBCType.VARCHAR.getVendorTypeNumber(), "String");
        return map;
    }
}

