/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.codegen;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.codegen.ClassNameResolver;
import org.komapper.codegen.Column;
import org.komapper.codegen.PropertyNameResolver;
import org.komapper.codegen.PropertyTypeResolver;
import org.komapper.codegen.Table;

public class CodeGenerator {
    private final String packageName;
    private final List<Table> tables;
    private final ClassNameResolver classNameResolver;
    private final PropertyNameResolver propertyNameResolver;

    public CodeGenerator(@Nullable String packageName, @NotNull List<Table> tables, @NotNull ClassNameResolver classNameResolver, @NotNull PropertyNameResolver propertyNameResolver) {
        this.packageName = packageName;
        this.tables = new ArrayList<Table>((Collection)Objects.requireNonNull(tables));
        this.classNameResolver = Objects.requireNonNull(classNameResolver);
        this.propertyNameResolver = Objects.requireNonNull(propertyNameResolver);
    }

    @NotNull
    public Writer createNewFile(@NotNull Path destinationDir, @NotNull String fileName, boolean overwrite) throws IOException {
        Objects.requireNonNull(destinationDir);
        Path file = this.createFilePath(destinationDir, fileName);
        if (Files.exists(file, new LinkOption[0]) && !overwrite) {
            return Writer.nullWriter();
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        return new OutputStreamWriter(Files.newOutputStream(file, new OpenOption[0]), StandardCharsets.UTF_8);
    }

    public void generateEntities(@NotNull Writer writer, boolean declareAsNullable, @NotNull PropertyTypeResolver resolver) {
        Objects.requireNonNull(writer);
        Objects.requireNonNull(resolver);
        PrintWriter p = new PrintWriter(writer);
        if (this.packageName != null) {
            p.println("package " + this.packageName);
        }
        for (Table table : this.tables) {
            p.println();
            String className = this.classNameResolver.resolve(table);
            p.println("data class " + className + " (");
            for (Column column : table.getColumns()) {
                String propertyName = this.propertyNameResolver.resolve(column);
                String nullable = declareAsNullable || column.isNullable() ? "?" : "";
                String propertyClassName = resolver.resolve(table, column);
                p.println("    val " + propertyName + ": " + propertyClassName + nullable + ",");
            }
            p.println(")");
        }
    }

    public void generateDefinitions(@NotNull Writer writer, boolean useCatalog, boolean useSchema) {
        Objects.requireNonNull(writer);
        PrintWriter p = new PrintWriter(writer);
        if (this.packageName != null) {
            p.println("package " + this.packageName);
            p.println();
        }
        p.println("import org.komapper.annotation.KomapperAutoIncrement");
        p.println("import org.komapper.annotation.KomapperColumn");
        p.println("import org.komapper.annotation.KomapperEntityDef");
        p.println("import org.komapper.annotation.KomapperId");
        p.println("import org.komapper.annotation.KomapperTable");
        for (Table table : this.tables) {
            p.println();
            String className = this.classNameResolver.resolve(table);
            p.println("@KomapperEntityDef(" + className + "::class)");
            StringBuilder tableArgs = new StringBuilder();
            tableArgs.append('\"').append(table.getName()).append('\"');
            if (useCatalog && table.getCatalog() != null) {
                tableArgs.append(", ");
                tableArgs.append('\"').append(table.getCatalog()).append('\"');
            }
            if (useSchema && table.getSchema() != null) {
                tableArgs.append(", ");
                tableArgs.append('\"').append(table.getSchema()).append('\"');
            }
            p.println("@KomapperTable(" + tableArgs + ")");
            p.println("data class " + className + "Def (");
            for (Column column : table.getColumns()) {
                String propertyName = this.propertyNameResolver.resolve(column);
                String id = column.isPrimaryKey() ? "@KomapperId " : "";
                String autoIncrement = column.isAutoIncrement() ? "@KomapperAutoIncrement " : "";
                p.println("    " + id + autoIncrement + "@KomapperColumn(\"" + column.getName() + "\") val " + propertyName + ": Nothing,");
            }
            p.println(")");
        }
    }

    private Path createFilePath(Path destinationDir, String name) {
        Path packageDir;
        if (this.packageName == null) {
            packageDir = destinationDir;
        } else {
            String path = this.packageName.replace(".", "/");
            packageDir = destinationDir.resolve(path);
        }
        return packageDir.resolve(name);
    }
}

