/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.codegen;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.komapper.codegen.Column;
import org.komapper.codegen.Enquote;
import org.komapper.codegen.MutableColumn;
import org.komapper.codegen.MutableTable;
import org.komapper.codegen.PrimaryKey;
import org.komapper.codegen.Table;

public class MetadataReader {
    private final Enquote enquote;
    private final DatabaseMetaData metaData;
    private final String catalog;
    private final String schemaPattern;
    private final String tableNamePattern;
    private final List<String> tableTypes;

    public MetadataReader(Enquote enquote, DatabaseMetaData metaData, String catalog, String schemaPattern, String tableNamePattern, List<String> tableTypes) {
        this.enquote = Objects.requireNonNull(enquote);
        this.metaData = Objects.requireNonNull(metaData);
        this.catalog = catalog;
        this.schemaPattern = schemaPattern;
        this.tableNamePattern = tableNamePattern;
        this.tableTypes = new ArrayList<String>((Collection)Objects.requireNonNull(tableTypes));
    }

    @NotNull
    public List<Table> read() throws SQLException {
        List<MutableTable> tables = this.getTables();
        for (MutableTable table : tables) {
            List<PrimaryKey> primaryKeys = this.getPrimaryKeys(table);
            table.columns = this.getColumns(table, primaryKeys);
        }
        return new ArrayList<Table>(tables);
    }

    private List<MutableTable> getTables() throws SQLException {
        ArrayList<MutableTable> tables = new ArrayList<MutableTable>();
        try (ResultSet rs = this.metaData.getTables(this.catalog, this.schemaPattern, this.tableNamePattern, this.tableTypes.toArray(new String[0]));){
            while (rs.next()) {
                MutableTable table = new MutableTable();
                table.name = rs.getString("TABLE_NAME");
                table.catalog = rs.getString("TABLE_CAT");
                table.schema = rs.getString("TABLE_SCHEM");
                tables.add(table);
            }
        }
        return tables;
    }

    private List<Column> getColumns(Table table, List<PrimaryKey> primaryKeys) throws SQLException {
        ArrayList<Column> columns = new ArrayList<Column>();
        try (ResultSet rs = this.metaData.getColumns(table.getCatalog(), table.getSchema(), table.getName(), null);){
            HashMap<String, PrimaryKey> pkMap = new HashMap<String, PrimaryKey>();
            for (PrimaryKey pk : primaryKeys) {
                pkMap.put(pk.getName(), pk);
            }
            while (rs.next()) {
                String name = rs.getString("COLUMN_NAME");
                PrimaryKey primaryKey = (PrimaryKey)pkMap.get(name);
                MutableColumn column = new MutableColumn();
                column.name = name;
                column.dataType = rs.getInt("DATA_TYPE");
                column.typeName = rs.getString("TYPE_NAME");
                column.length = rs.getInt("COLUMN_SIZE");
                column.scale = rs.getInt("DECIMAL_DIGITS");
                column.nullable = rs.getBoolean("NULLABLE");
                column.isPrimaryKey = primaryKey != null;
                column.isAutoIncrement = primaryKey != null && primaryKey.isAutoIncrement();
                columns.add(column);
            }
        }
        return columns;
    }

    private List<PrimaryKey> getPrimaryKeys(Table table) throws SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        try (ResultSet rs = this.metaData.getPrimaryKeys(table.getCatalog(), table.getSchema(), table.getName());){
            while (rs.next()) {
                keys.add(rs.getString("COLUMN_NAME"));
            }
        }
        if (keys.size() == 1) {
            String key = (String)keys.get(0);
            boolean isAutoIncrement = this.isAutoIncrement(table, key);
            PrimaryKey primaryKey = new PrimaryKey(key, isAutoIncrement);
            return List.of(primaryKey);
        }
        return keys.stream().map(it -> new PrimaryKey((String)it, false)).collect(Collectors.toList());
    }

    private boolean isAutoIncrement(Table table, String key) throws SQLException {
        Connection con = this.metaData.getConnection();
        try (Statement statement = con.createStatement();){
            boolean bl;
            block12: {
                String columnName = this.enquote.apply(key);
                String tableName = table.getCanonicalTableName(this.enquote);
                ResultSet rs = statement.executeQuery("select " + columnName + " from " + tableName + " where 1 = 0");
                try {
                    bl = rs.getMetaData().isAutoIncrement(1);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }
}

