/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor;

import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeAlias;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeParameter;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueArgument;
import com.google.devtools.ksp.symbol.KSVisitor;
import com.google.devtools.ksp.symbol.Modifier;
import com.google.devtools.ksp.symbol.Nullability;
import com.google.devtools.ksp.visitor.KSEmptyVisitor;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.processor.TypeArgumentResolver;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00010\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\u0016\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e*\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\n*\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\u0016\u0010\u0012\u001a\u0004\u0018\u00010\n*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\fH\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u0001*\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\"\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016*\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0000\u001a\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0000\u001a\u0018\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\fH\u0002\u001a\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\fH\u0000\u001a\u0010\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\fH\u0000\u001a\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000e2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0017H\u0000\u001a:\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000e2\u0006\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u001a\b\u0002\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020)0-0\u000eH\u0002\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\"\u0018\u0010\u001c\u001a\u00020\f*\u00020\u00178@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006/"}, d2={"hasDuplicates", "", "T", "", "predicate", "Lkotlin/Function1;", "isValueClass", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "findValue", "", "Lcom/google/devtools/ksp/symbol/KSAnnotation;", "name", "", "findAnnotations", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "klass", "Lkotlin/reflect/KClass;", "findAnnotation", "simpleName", "hasAnnotation", "normalize", "Lkotlin/Pair;", "Lcom/google/devtools/ksp/symbol/KSType;", "Lorg/komapper/processor/TypeArgumentResolver;", "parent", "getName", "(Lcom/google/devtools/ksp/symbol/KSType;)Ljava/lang/String;", "backquotedName", "getBackquotedName", "createBackquotedName", "declaration", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "createTypeName", "type", "baseName", "toCamelCase", "text", "resolveLiteralTag", "typeName", "resolveTypeArgumentsOfAncestor", "Lcom/google/devtools/ksp/symbol/KSTypeArgument;", "descendantType", "ancestorType", "typeMapList", "", "Lcom/google/devtools/ksp/symbol/KSTypeParameter;", "komapper-processor"})
@SourceDebugExtension(value={"SMAP\nProcessorUtility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessorUtility.kt\norg/komapper/processor/ProcessorUtilityKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,222:1\n774#2:223\n865#2,2:224\n774#2:226\n865#2,2:227\n1557#2:229\n1628#2,3:230\n183#3,2:233\n183#3,2:235\n*S KotlinDebug\n*F\n+ 1 ProcessorUtility.kt\norg/komapper/processor/ProcessorUtilityKt\n*L\n19#1:223\n19#1:224,2\n35#1:226\n35#1:227,2\n36#1:229\n36#1:230,3\n45#1:233,2\n49#1:235,2\n*E\n"})
public final class ProcessorUtilityKt {
    /*
     * WARNING - void declaration
     */
    public static final <T> boolean hasDuplicates(@NotNull Iterable<? extends T> $this$hasDuplicates, @NotNull Function1<? super T, Boolean> predicate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$hasDuplicates, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Iterable<? extends T> $this$filter$iv = $this$hasDuplicates;
        boolean $i$f$filter = false;
        Iterable<? extends T> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)predicate.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((Collection)CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)2)).size() == 2;
    }

    public static final boolean isValueClass(@NotNull KSClassDeclaration $this$isValueClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isValueClass, (String)"<this>");
        return $this$isValueClass.getModifiers().contains(Modifier.VALUE) ? true : $this$isValueClass.getModifiers().contains(Modifier.INLINE);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final Object findValue(@NotNull KSAnnotation $this$findValue, @NotNull String name) {
        void $this$mapTo$iv$iv;
        KSValueArgument it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable $this$filter$iv = $this$findValue.getArguments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KSValueArgument)element$iv$iv;
            boolean bl = false;
            KSName kSName = it.getName();
            if (!Intrinsics.areEqual((Object)(kSName != null ? kSName.asString() : null), (Object)name)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KSValueArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        return CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    @NotNull
    public static final List<KSAnnotation> findAnnotations(@NotNull KSAnnotated $this$findAnnotations, @NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter((Object)$this$findAnnotations, (String)"<this>");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)$this$findAnnotations.getAnnotations(), arg_0 -> ProcessorUtilityKt.findAnnotations$lambda$2(klass, arg_0)));
    }

    @Nullable
    public static final KSAnnotation findAnnotation(@NotNull KSAnnotated $this$findAnnotation, @NotNull KClass<?> klass) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findAnnotation, (String)"<this>");
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            Sequence $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KSAnnotation it = (KSAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getShortName().asString(), (Object)klass.getSimpleName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final KSAnnotation findAnnotation(@NotNull KSAnnotated $this$findAnnotation, @NotNull String simpleName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findAnnotation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)simpleName, (String)"simpleName");
            Sequence $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KSAnnotation it = (KSAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getShortName().asString(), (Object)simpleName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final boolean hasAnnotation(@NotNull KSAnnotated $this$hasAnnotation, @NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter((Object)$this$hasAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        return ProcessorUtilityKt.findAnnotation($this$hasAnnotation, klass) != null;
    }

    @NotNull
    public static final Pair<KSType, TypeArgumentResolver> normalize(@NotNull KSType $this$normalize, @NotNull TypeArgumentResolver parent) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return (Pair)$this$normalize.getDeclaration().accept((KSVisitor)new KSEmptyVisitor<Unit, Pair<? extends KSType, ? extends TypeArgumentResolver>>(parent, $this$normalize){
            final /* synthetic */ TypeArgumentResolver $parent;
            final /* synthetic */ KSType $this_normalize;
            {
                this.$parent = $parent;
                this.$this_normalize = $receiver;
            }

            public Pair<KSType, TypeArgumentResolver> defaultHandler(KSNode node, Unit data) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                TypeArgumentResolver resolver = new TypeArgumentResolver(this.$parent, this.$this_normalize.getDeclaration().getTypeParameters(), this.$this_normalize.getArguments());
                return TuplesKt.to((Object)this.$this_normalize, (Object)resolver);
            }

            public Pair<KSType, TypeArgumentResolver> visitTypeAlias(KSTypeAlias typeAlias, Unit data) {
                Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                TypeArgumentResolver resolver = new TypeArgumentResolver(this.$parent, typeAlias.getTypeParameters(), this.$this_normalize.getArguments());
                KSType kSType = typeAlias.getType().resolve();
                KSType kSType2 = this.$this_normalize;
                KSType it = kSType;
                boolean bl = false;
                KSType type = kSType2.isMarkedNullable() ? it.makeNullable() : it;
                return ProcessorUtilityKt.normalize(type, resolver);
            }
        }, (Object)Unit.INSTANCE);
    }

    public static /* synthetic */ Pair normalize$default(KSType kSType, TypeArgumentResolver typeArgumentResolver, int n, Object object) {
        if ((n & 1) != 0) {
            typeArgumentResolver = new TypeArgumentResolver(null, null, null, 7, null);
        }
        return ProcessorUtilityKt.normalize(kSType, typeArgumentResolver);
    }

    @NotNull
    public static final String getName(@NotNull KSType $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"<this>");
        return ProcessorUtilityKt.createTypeName($this$name, ProcessorUtilityKt._get_name_$asString($this$name));
    }

    @NotNull
    public static final String getBackquotedName(@NotNull KSType $this$backquotedName) {
        Intrinsics.checkNotNullParameter((Object)$this$backquotedName, (String)"<this>");
        return ProcessorUtilityKt.createTypeName($this$backquotedName, ProcessorUtilityKt._get_backquotedName_$asString$5($this$backquotedName));
    }

    @NotNull
    public static final String createBackquotedName(@NotNull KSDeclaration declaration) {
        Object object;
        String qualifiedName;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KSName kSName = declaration.getQualifiedName();
        String string = qualifiedName = kSName != null ? kSName.asString() : null;
        if (qualifiedName == null) {
            object = declaration.getSimpleName().asString();
        } else {
            String packageName = declaration.getPackageName().asString();
            if (((CharSequence)packageName).length() == 0) {
                object = qualifiedName;
            } else {
                String string2 = qualifiedName.substring(packageName.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String remains = string2;
                char[] cArray = new char[]{'.'};
                object = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)packageName, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, ProcessorUtilityKt::createBackquotedName$lambda$6, (int)30, null) + remains;
            }
        }
        return object;
    }

    private static final String createTypeName(KSType type, String baseName) {
        StringBuilder buf = new StringBuilder();
        buf.append(baseName);
        if (!((Collection)type.getArguments()).isEmpty()) {
            buf.append("<");
            CollectionsKt.joinTo$default((Iterable)type.getArguments(), (Appendable)buf, null, null, null, (int)0, null, ProcessorUtilityKt::createTypeName$lambda$7, (int)62, null);
            buf.append(">");
        }
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String toCamelCase(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        StringBuilder builder = new StringBuilder();
        CharBuffer buf = CharBuffer.wrap(text);
        if (buf.hasRemaining()) {
            builder.append(Character.toLowerCase(buf.get()));
        }
        while (buf.hasRemaining()) {
            CharSequence charSequence;
            char c1 = buf.get();
            buf.mark();
            if (buf.hasRemaining()) {
                char c2 = buf.get();
                if (Character.isUpperCase(c1) && Character.isLowerCase(c2)) {
                    builder.append(c1).append(c2).append(buf);
                    break;
                }
                builder.append(Character.toLowerCase(c1));
                charSequence = buf.reset();
                continue;
            }
            charSequence = builder.append(Character.toLowerCase(c1));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String resolveLiteralTag(@NotNull String typeName) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        String string = typeName;
        return Intrinsics.areEqual((Object)string, (Object)"kotlin.Long") ? "L" : (Intrinsics.areEqual((Object)string, (Object)"kotlin.UInt") ? "u" : "");
    }

    @NotNull
    public static final List<KSTypeArgument> resolveTypeArgumentsOfAncestor(@NotNull KSType descendantType, @NotNull KSType ancestorType) {
        Intrinsics.checkNotNullParameter((Object)descendantType, (String)"descendantType");
        Intrinsics.checkNotNullParameter((Object)ancestorType, (String)"ancestorType");
        if (ancestorType.getArguments().isEmpty() || !ancestorType.isAssignableFrom(descendantType)) {
            return CollectionsKt.emptyList();
        }
        Map typeMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)descendantType.getDeclaration().getTypeParameters(), (Iterable)descendantType.getArguments()));
        return ProcessorUtilityKt.resolveTypeArgumentsOfAncestor(descendantType, ancestorType, CollectionsKt.listOf((Object)typeMap));
    }

    private static final List<KSTypeArgument> resolveTypeArgumentsOfAncestor(KSType descendantType, KSType ancestorType, List<? extends Map<KSTypeParameter, ? extends KSTypeArgument>> typeMapList) {
        if (!Intrinsics.areEqual((Object)descendantType.getDeclaration(), (Object)ancestorType.getDeclaration())) {
            KSDeclaration kSDeclaration = descendantType.getDeclaration();
            Intrinsics.checkNotNull((Object)kSDeclaration, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
            KSClassDeclaration descendantDecl = (KSClassDeclaration)kSDeclaration;
            for (KSTypeReference superTypeRef : descendantDecl.getSuperTypes()) {
                Map typeMap;
                List newTypeMapList;
                List<KSTypeArgument> typeArgs;
                KSType superType = superTypeRef.resolve();
                if (!ancestorType.isAssignableFrom(superType) || !(!((Collection)(typeArgs = ProcessorUtilityKt.resolveTypeArgumentsOfAncestor(superType, ancestorType, newTypeMapList = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)(typeMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)superType.getDeclaration().getTypeParameters(), (Iterable)superType.getArguments())))), (Iterable)typeMapList)))).isEmpty())) continue;
                return typeArgs;
            }
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.zip((Iterable)descendantType.getDeclaration().getTypeParameters(), (Iterable)descendantType.getArguments())), arg_0 -> ProcessorUtilityKt.resolveTypeArgumentsOfAncestor$lambda$8(typeMapList, arg_0)));
    }

    static /* synthetic */ List resolveTypeArgumentsOfAncestor$default(KSType kSType, KSType kSType2, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return ProcessorUtilityKt.resolveTypeArgumentsOfAncestor(kSType, kSType2, list);
    }

    private static final boolean findAnnotations$lambda$2(KClass $klass, KSAnnotation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getShortName().asString(), (Object)$klass.getSimpleName());
    }

    private static final String _get_name_$asString(KSType $this_name) {
        KSName kSName = $this_name.getDeclaration().getQualifiedName();
        if (kSName == null) {
            kSName = $this_name.getDeclaration().getSimpleName();
        }
        return kSName.asString();
    }

    private static final String _get_backquotedName_$asString$5(KSType $this_backquotedName) {
        return ProcessorUtilityKt.createBackquotedName($this_backquotedName.getDeclaration());
    }

    private static final CharSequence createBackquotedName$lambda$6(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "`" + it + "`";
    }

    private static final CharSequence createTypeName$lambda$7(KSTypeArgument it) {
        CharSequence charSequence;
        KSType t;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KSTypeReference kSTypeReference = it.getType();
        Object object = t = kSTypeReference != null ? kSTypeReference.resolve() : null;
        if (t == null) {
            charSequence = it.getVariance().getLabel();
        } else {
            String mark = t.getNullability() == Nullability.NULLABLE ? "?" : "";
            charSequence = ProcessorUtilityKt.getName(t) + mark;
        }
        return charSequence;
    }

    private static final KSTypeArgument resolveTypeArgumentsOfAncestor$lambda$8(List $typeMapList, Pair it) {
        Map typeMap;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KSDeclaration formal = (KSDeclaration)it.getFirst();
        KSTypeArgument actual = (KSTypeArgument)it.getSecond();
        Iterator iterator = $typeMapList.iterator();
        while (iterator.hasNext() && (KSTypeArgument)(typeMap = (Map)iterator.next()).get(formal) != null) {
            KSTypeReference kSTypeReference = actual.getType();
            formal = kSTypeReference != null && (kSTypeReference = kSTypeReference.resolve()) != null ? kSTypeReference.getDeclaration() : null;
        }
        return actual;
    }
}

