/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor.command;

import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSNode;
import java.util.Collection;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.template.expression.CacheExprNodeFactory;
import org.komapper.core.template.expression.ExprNodeFactory;
import org.komapper.core.template.sql.CacheSqlNodeFactory;
import org.komapper.core.template.sql.SqlException;
import org.komapper.core.template.sql.SqlNodeFactory;
import org.komapper.processor.Context;
import org.komapper.processor.Exit;
import org.komapper.processor.ExitKt;
import org.komapper.processor.command.Command;
import org.komapper.processor.command.CommandAnalysisResult;
import org.komapper.processor.command.CommandFactory;
import org.komapper.processor.command.ExprValidator;
import org.komapper.processor.command.SqlReassembler;
import org.komapper.processor.command.SqlValidator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/komapper/processor/command/CommandAnalyzer;", "", "context", "Lorg/komapper/processor/Context;", "annotationClass", "Lkotlin/reflect/KClass;", "<init>", "(Lorg/komapper/processor/Context;Lkotlin/reflect/KClass;)V", "sqlNodeFactory", "Lorg/komapper/core/template/sql/CacheSqlNodeFactory;", "exprValidator", "Lorg/komapper/processor/command/ExprValidator;", "analyze", "Lorg/komapper/processor/command/CommandAnalysisResult;", "symbol", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "reassembleSql", "Lorg/komapper/processor/command/Command;", "command", "validateCommand", "", "komapper-processor"})
public final class CommandAnalyzer {
    @NotNull
    private final Context context;
    @NotNull
    private final KClass<?> annotationClass;
    @NotNull
    private final CacheSqlNodeFactory sqlNodeFactory;
    @NotNull
    private final ExprValidator exprValidator;

    public CommandAnalyzer(@NotNull Context context, @NotNull KClass<?> annotationClass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        this.context = context;
        this.annotationClass = annotationClass;
        this.sqlNodeFactory = new CacheSqlNodeFactory();
        this.exprValidator = new ExprValidator(this.context, (ExprNodeFactory)new CacheExprNodeFactory());
    }

    @NotNull
    public final CommandAnalysisResult analyze(@NotNull KSAnnotated symbol) {
        Command command;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        try {
            Command it = new CommandFactory(this.context, this.annotationClass, symbol).create();
            boolean bl = false;
            command = this.reassembleSql(it);
        }
        catch (Exit e) {
            return new CommandAnalysisResult.Error(e);
        }
        Command command2 = command;
        if (!command2.getDisableValidation()) {
            try {
                this.validateCommand(command2);
            }
            catch (Exit e) {
                return new CommandAnalysisResult.Failure(command2, e);
            }
        }
        return new CommandAnalysisResult.Success(command2);
    }

    private final Command reassembleSql(Command command) {
        String string;
        try {
            string = new SqlReassembler(this.context, command.getSql(), command.getParamMap(), (SqlNodeFactory)this.sqlNodeFactory, this.exprValidator).assemble();
        }
        catch (SqlException e) {
            ExitKt.report("SQL reassembly error: " + e.getMessage(), (KSNode)command.getAnnotation());
            throw new KotlinNothingValueException();
        }
        String sql = string;
        return Command.copy$default(command, null, sql, false, null, null, null, null, null, null, null, null, 2045, null);
    }

    private final void validateCommand(Command command) {
        Set<String> set;
        try {
            set = new SqlValidator(this.context, command.getSql(), command.getParamMap(), (SqlNodeFactory)this.sqlNodeFactory, this.exprValidator).validate();
        }
        catch (SqlException e) {
            ExitKt.report("SQL validation error: " + e.getMessage(), (KSNode)command.getAnnotation());
            throw new KotlinNothingValueException();
        }
        Set<String> usedParams = set;
        Set unusedParams = SetsKt.minus((Set)SetsKt.minus(command.getParamMap().keySet(), (Iterable)usedParams), (Iterable)command.getUnusedParams());
        if (!((Collection)unusedParams).isEmpty()) {
            this.context.getLogger().warn("Unused SQL params: " + unusedParams + ". You can suppress this warning message by specifying @KomapperUnused for the param properties.", (KSNode)command.getClassDeclaration());
        }
    }
}

