/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor.entity;

import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSNode;
import java.util.Collection;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.komapper.annotation.KomapperEmbeddedId;
import org.komapper.annotation.KomapperId;
import org.komapper.processor.Context;
import org.komapper.processor.Exit;
import org.komapper.processor.ExitKt;
import org.komapper.processor.entity.Entity;
import org.komapper.processor.entity.EntityAnalysisResult;
import org.komapper.processor.entity.EntityDef;
import org.komapper.processor.entity.EntityDefFactory;
import org.komapper.processor.entity.EntityDefinitionSource;
import org.komapper.processor.entity.EntityDefinitionSourceResolver;
import org.komapper.processor.entity.EntityFactory;
import org.komapper.processor.entity.EntityModel;
import org.komapper.processor.entity.Property;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/komapper/processor/entity/EntityAnalyzer;", "", "context", "Lorg/komapper/processor/Context;", "definitionSourceResolver", "Lorg/komapper/processor/entity/EntityDefinitionSourceResolver;", "requiresIdValidation", "", "<init>", "(Lorg/komapper/processor/Context;Lorg/komapper/processor/entity/EntityDefinitionSourceResolver;Z)V", "analyze", "Lorg/komapper/processor/entity/EntityAnalysisResult;", "symbol", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "validateEntity", "", "entity", "Lorg/komapper/processor/entity/Entity;", "komapper-processor"})
public final class EntityAnalyzer {
    @NotNull
    private final Context context;
    @NotNull
    private final EntityDefinitionSourceResolver definitionSourceResolver;
    private final boolean requiresIdValidation;

    public EntityAnalyzer(@NotNull Context context, @NotNull EntityDefinitionSourceResolver definitionSourceResolver, boolean requiresIdValidation) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)definitionSourceResolver, (String)"definitionSourceResolver");
        this.context = context;
        this.definitionSourceResolver = definitionSourceResolver;
        this.requiresIdValidation = requiresIdValidation;
    }

    @NotNull
    public final EntityAnalysisResult analyze(@NotNull KSAnnotated symbol) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        try {
            object2 = this.definitionSourceResolver.resolve(symbol);
        }
        catch (Exit e) {
            return new EntityAnalysisResult.Error(e);
        }
        EntityDefinitionSource definitionSource = object2;
        if (definitionSource == null) {
            object = EntityAnalysisResult.Skip.INSTANCE;
        } else {
            try {
                EntityDef entityDef = new EntityDefFactory(this.context, definitionSource).create();
                Entity entity = new EntityFactory(this.context, entityDef).create();
                this.validateEntity(entity);
                EntityModel model = new EntityModel(definitionSource, entity);
                object2 = new EntityAnalysisResult.Success(model);
            }
            catch (Exit e) {
                EntityModel model = new EntityModel(definitionSource, null, 2, null);
                object2 = new EntityAnalysisResult.Failure(model, e);
            }
            object = object2;
        }
        return object;
    }

    private final void validateEntity(Entity entity) {
        if (StringsKt.startsWith$default((String)entity.getDeclaration().getSimpleName().asString(), (String)"__", (boolean)false, (int)2, null)) {
            ExitKt.report("The class name cannot start with '__'.", (KSNode)entity.getDeclaration());
            throw new KotlinNothingValueException();
        }
        for (Property p : entity.getProperties()) {
            String name = p.getDeclaration().getSimpleName().asString();
            if (!StringsKt.startsWith$default((String)name, (String)"__", (boolean)false, (int)2, null)) continue;
            ExitKt.report("The property name cannot start with '__'.", p.getNode());
            throw new KotlinNothingValueException();
        }
        if (this.requiresIdValidation) {
            if (entity.getEmbeddedIdProperty() == null && entity.getIdProperties().isEmpty()) {
                ExitKt.report("The entity class must have at least one id property.", (KSNode)entity.getDeclaration());
                throw new KotlinNothingValueException();
            }
            if (entity.getEmbeddedIdProperty() != null && !((Collection)entity.getIdProperties()).isEmpty()) {
                ExitKt.report("The entity class can have either @" + Reflection.getOrCreateKotlinClass(KomapperEmbeddedId.class).getSimpleName() + " or @" + Reflection.getOrCreateKotlinClass(KomapperId.class).getSimpleName() + ".", (KSNode)entity.getDeclaration());
                throw new KotlinNothingValueException();
            }
        }
    }
}

