/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor.entity;

import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.processor.entity.DataKt;
import org.komapper.processor.entity.Entity;
import org.komapper.processor.entity.EntityDefinitionSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/komapper/processor/entity/EntityModel;", "", "definitionSource", "Lorg/komapper/processor/entity/EntityDefinitionSource;", "entity", "Lorg/komapper/processor/entity/Entity;", "<init>", "(Lorg/komapper/processor/entity/EntityDefinitionSource;Lorg/komapper/processor/entity/Entity;)V", "getEntity", "()Lorg/komapper/processor/entity/Entity;", "hasStubAnnotation", "", "getHasStubAnnotation", "()Z", "entityDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "getEntityDeclaration", "()Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "aliases", "", "", "getAliases", "()Ljava/util/List;", "typeName", "getTypeName", "()Ljava/lang/String;", "unitTypeName", "getUnitTypeName", "containingFiles", "Lcom/google/devtools/ksp/symbol/KSFile;", "getContainingFiles", "createMetamodelClassName", "Lkotlin/Pair;", "komapper-processor"})
public final class EntityModel {
    @NotNull
    private final EntityDefinitionSource definitionSource;
    @Nullable
    private final Entity entity;
    private final boolean hasStubAnnotation;
    @NotNull
    private final KSClassDeclaration entityDeclaration;
    @NotNull
    private final List<String> aliases;
    @NotNull
    private final String typeName;
    @NotNull
    private final String unitTypeName;

    public EntityModel(@NotNull EntityDefinitionSource definitionSource, @Nullable Entity entity) {
        Intrinsics.checkNotNullParameter((Object)definitionSource, (String)"definitionSource");
        this.definitionSource = definitionSource;
        this.entity = entity;
        this.hasStubAnnotation = this.definitionSource.getStubAnnotation() != null;
        this.entityDeclaration = this.definitionSource.getEntityDeclaration();
        this.aliases = DataKt.getNames(this.definitionSource);
        this.typeName = DataKt.getTypeName(this.definitionSource);
        this.unitTypeName = this.definitionSource.getUnitTypeName();
    }

    public /* synthetic */ EntityModel(EntityDefinitionSource entityDefinitionSource, Entity entity, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            entity = null;
        }
        this(entityDefinitionSource, entity);
    }

    @Nullable
    public final Entity getEntity() {
        return this.entity;
    }

    public final boolean getHasStubAnnotation() {
        return this.hasStubAnnotation;
    }

    @NotNull
    public final KSClassDeclaration getEntityDeclaration() {
        return this.entityDeclaration;
    }

    @NotNull
    public final List<String> getAliases() {
        return this.aliases;
    }

    @NotNull
    public final String getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final String getUnitTypeName() {
        return this.unitTypeName;
    }

    @NotNull
    public final List<KSFile> getContainingFiles() {
        List list;
        KSClassDeclaration entityDeclaration;
        KSClassDeclaration defDeclaration = this.definitionSource.getDefDeclaration();
        if (Intrinsics.areEqual((Object)defDeclaration, (Object)(entityDeclaration = this.definitionSource.getEntityDeclaration()))) {
            list = CollectionsKt.listOfNotNull((Object)defDeclaration.getContainingFile());
        } else {
            Object[] objectArray = new KSFile[]{defDeclaration.getContainingFile(), entityDeclaration.getContainingFile()};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        }
        return list;
    }

    @NotNull
    public final Pair<String, String> createMetamodelClassName() {
        return TuplesKt.to((Object)this.definitionSource.getPackageName(), (Object)this.definitionSource.getMetamodelSimpleName());
    }
}

