/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor.command;

import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSFile;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.komapper.annotation.KomapperCommand;
import org.komapper.processor.Context;
import org.komapper.processor.ContextFactory;
import org.komapper.processor.Exit;
import org.komapper.processor.command.Command;
import org.komapper.processor.command.CommandAnalysisResult;
import org.komapper.processor.command.CommandAnalyzer;
import org.komapper.processor.command.CommandCallGenerator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/komapper/processor/command/CommandProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "contextFactory", "Lorg/komapper/processor/ContextFactory;", "<init>", "(Lorg/komapper/processor/ContextFactory;)V", "annotationClass", "Lkotlin/reflect/KClass;", "Lorg/komapper/annotation/KomapperCommand;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "log", "", "context", "Lorg/komapper/processor/Context;", "exit", "Lorg/komapper/processor/Exit;", "generateMetamodel", "command", "Lorg/komapper/processor/command/Command;", "komapper-processor"})
@SourceDebugExtension(value={"SMAP\nCommandProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandProcessor.kt\norg/komapper/processor/command/CommandProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,55:1\n1#2:56\n37#3:57\n36#3,3:58\n*S KotlinDebug\n*F\n+ 1 CommandProcessor.kt\norg/komapper/processor/command/CommandProcessor\n*L\n47#1:57\n47#1:58,3\n*E\n"})
public final class CommandProcessor
implements SymbolProcessor {
    @NotNull
    private final ContextFactory contextFactory;
    @NotNull
    private final KClass<KomapperCommand> annotationClass;

    public CommandProcessor(@NotNull ContextFactory contextFactory) {
        Intrinsics.checkNotNullParameter((Object)contextFactory, (String)"contextFactory");
        this.contextFactory = contextFactory;
        this.annotationClass = Reflection.getOrCreateKotlinClass(KomapperCommand.class);
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Context context = this.contextFactory.create(resolver);
        String string = this.annotationClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        Sequence symbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string, (boolean)false, (int)2, null);
        Iterator iterator = symbols.iterator();
        while (iterator.hasNext()) {
            CommandAnalyzer analyzer = new CommandAnalyzer(context, this.annotationClass);
            KSAnnotated symbol = (KSAnnotated)iterator.next();
            CommandAnalysisResult result = analyzer.analyze(symbol);
            if (result instanceof CommandAnalysisResult.Success) {
                this.generateMetamodel(context, ((CommandAnalysisResult.Success)result).getCommand());
                continue;
            }
            if (result instanceof CommandAnalysisResult.Failure) {
                this.log(context, ((CommandAnalysisResult.Failure)result).getExit());
                this.generateMetamodel(context, ((CommandAnalysisResult.Failure)result).getCommand());
                continue;
            }
            if (result instanceof CommandAnalysisResult.Error) {
                this.log(context, ((CommandAnalysisResult.Error)result).getExit());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return CollectionsKt.emptyList();
    }

    private final void log(Context context, Exit exit) {
        context.getLogger().error(exit.getReport().getMessage(), exit.getReport().getNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateMetamodel(Context context, Command command) {
        Object object;
        block15: {
            block14: {
                object = command.getClassDeclaration().getContainingFile();
                if (object == null) break block14;
                KSFile it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)it);
                object = list;
                if (list != null) break block15;
            }
            object = CollectionsKt.emptyList();
        }
        Object files = object;
        Collection $this$toTypedArray$iv = (Collection)files;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object object2 = thisCollection$iv.toArray(new KSFile[0]);
        Dependencies dependencies = new Dependencies(false, Arrays.copyOf(object2, ((KSFile[])object2).length));
        object2 = CodeGenerator.createNewFile$default((CodeGenerator)context.getCodeGenerator(), (Dependencies)dependencies, (String)command.getPackageName(), (String)command.getFileName(), null, (int)8, null);
        Throwable throwable = null;
        try {
            OutputStream out = (OutputStream)object2;
            boolean bl = false;
            Closeable closeable = new PrintWriter(out);
            Throwable throwable2 = null;
            try {
                PrintWriter writer = (PrintWriter)closeable;
                boolean bl2 = false;
                new CommandCallGenerator(command, writer).run();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
        }
    }
}

