/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor.command;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.KSAnnotation;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSName;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSType;
import com.google.devtools.ksp.symbol.KSTypeArgument;
import com.google.devtools.ksp.symbol.KSTypeReference;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.google.devtools.ksp.symbol.Nullability;
import com.google.devtools.ksp.symbol.Variance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.komapper.core.template.expression.ExprException;
import org.komapper.core.template.expression.ExprLocation;
import org.komapper.core.template.expression.ExprNode;
import org.komapper.core.template.expression.ExprNodeFactory;
import org.komapper.core.template.expression.NoCacheExprNodeFactory;
import org.komapper.processor.Context;
import org.komapper.processor.ContextKt;
import org.komapper.processor.command.ExprEvalResult;
import org.komapper.processor.command.ExprValidator;
import org.komapper.processor.command.ExprValidator$findProperty$;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001:\rEFGHIJKLMNOPQB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$J$\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J,\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020'2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J4\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020'2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J4\u0010.\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020'2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J4\u0010/\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020'2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J4\u00100\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020'2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J4\u00101\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020'2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J$\u00102\u001a\u00020\t2\u0006\u0010&\u001a\u0002032\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J$\u00104\u001a\u00020\t2\u0006\u0010&\u001a\u0002052\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J$\u00106\u001a\u00020\t2\u0006\u0010&\u001a\u0002072\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J,\u00108\u001a\u00020\t2\u0006\u00109\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J$\u0010:\u001a\u00020\t2\u0006\u0010&\u001a\u00020;2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J\u001a\u0010<\u001a\u0004\u0018\u00010\t2\u0006\u00109\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\tH\u0002J\u001a\u0010>\u001a\u0004\u0018\u00010\t2\u0006\u00109\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\tH\u0002J$\u0010?\u001a\u00020\t2\u0006\u0010&\u001a\u00020@2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\t0$H\u0002J(\u0010A\u001a\u0004\u0018\u00010\t2\u0006\u00109\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\t2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\t0CH\u0002J(\u0010D\u001a\u0004\u0018\u00010\t2\u0006\u00109\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\t2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\t0CH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0010\u001a\u0004\b\u0017\u0010\u0014R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006R"}, d2={"Lorg/komapper/processor/command/ExprValidator;", "", "context", "Lorg/komapper/processor/Context;", "exprNodeFactory", "Lorg/komapper/core/template/expression/ExprNodeFactory;", "<init>", "(Lorg/komapper/processor/Context;Lorg/komapper/core/template/expression/ExprNodeFactory;)V", "stringType", "Lcom/google/devtools/ksp/symbol/KSType;", "booleanType", "unitType", "comparableType", "getComparableType", "()Lcom/google/devtools/ksp/symbol/KSType;", "comparableType$delegate", "Lkotlin/Lazy;", "templateExtensionsDeclaration", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "getTemplateExtensionsDeclaration", "()Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "templateExtensionsDeclaration$delegate", "arrayDeclaration", "getArrayDeclaration", "arrayDeclaration$delegate", "referencedParams", "", "", "usedParams", "", "getUsedParams", "()Ljava/util/Set;", "validate", "Lorg/komapper/processor/command/ExprEvalResult;", "expression", "paramMap", "", "visit", "node", "Lorg/komapper/core/template/expression/ExprNode;", "perform", "location", "Lorg/komapper/core/template/expression/ExprLocation;", "operand", "leftNode", "rightNode", "equal", "compare", "visitIs", "visitAs", "visitClassRef", "Lorg/komapper/core/template/expression/ExprNode$ClassRef;", "visitValue", "Lorg/komapper/core/template/expression/ExprNode$Value;", "visitCallableValue", "Lorg/komapper/core/template/expression/ExprNode$CallableValue;", "getParamType", "name", "visitProperty", "Lorg/komapper/core/template/expression/ExprNode$Property;", "findProperty", "receiver", "findExtensionProperty", "visitFunction", "Lorg/komapper/core/template/expression/ExprNode$Function;", "findFunction", "argList", "", "findExtensionFunction", "KSTypeList", "EitherOperandNonBooleanException", "NonBooleanTypeException", "NonSameTypeException", "NonComparableTypeException", "InvokeFunctionNotFoundException", "ArgumentCountMismatchException", "ReturnTypeNotFoundException", "FunctionNotFoundException", "PropertyNotFoundException", "ParameterNotFoundException", "ClassNotFoundException", "NotClassRefNodeException", "komapper-processor"})
@SourceDebugExtension(value={"SMAP\nExprValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExprValidator.kt\norg/komapper/processor/command/ExprValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,404:1\n1563#2:405\n1634#2,3:406\n1740#2,3:414\n1740#2,3:417\n183#3,2:409\n477#3:411\n183#3,2:412\n*S KotlinDebug\n*F\n+ 1 ExprValidator.kt\norg/komapper/processor/command/ExprValidator\n*L\n89#1:405\n89#1:406,3\n320#1:414,3\n336#1:417,3\n257#1:409,2\n261#1:411\n263#1:412,2\n*E\n"})
public final class ExprValidator {
    @NotNull
    private final Context context;
    @NotNull
    private final ExprNodeFactory exprNodeFactory;
    @NotNull
    private final KSType stringType;
    @NotNull
    private final KSType booleanType;
    @NotNull
    private final KSType unitType;
    @NotNull
    private final Lazy comparableType$delegate;
    @NotNull
    private final Lazy templateExtensionsDeclaration$delegate;
    @NotNull
    private final Lazy arrayDeclaration$delegate;
    @NotNull
    private final Set<String> referencedParams;

    public ExprValidator(@NotNull Context context, @NotNull ExprNodeFactory exprNodeFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)exprNodeFactory, (String)"exprNodeFactory");
        this.context = context;
        this.exprNodeFactory = exprNodeFactory;
        this.stringType = this.context.getResolver().getBuiltIns().getStringType();
        this.booleanType = this.context.getResolver().getBuiltIns().getBooleanType();
        this.unitType = this.context.getResolver().getBuiltIns().getUnitType();
        this.comparableType$delegate = LazyKt.lazy(() -> ExprValidator.comparableType_delegate$lambda$0(this));
        this.templateExtensionsDeclaration$delegate = LazyKt.lazy(() -> ExprValidator.templateExtensionsDeclaration_delegate$lambda$1(this));
        this.arrayDeclaration$delegate = LazyKt.lazy(() -> ExprValidator.arrayDeclaration_delegate$lambda$2(this));
        this.referencedParams = new LinkedHashSet();
    }

    public /* synthetic */ ExprValidator(Context context, ExprNodeFactory exprNodeFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            exprNodeFactory = (ExprNodeFactory)new NoCacheExprNodeFactory();
        }
        this(context, exprNodeFactory);
    }

    private final KSType getComparableType() {
        Lazy lazy = this.comparableType$delegate;
        return (KSType)lazy.getValue();
    }

    private final KSClassDeclaration getTemplateExtensionsDeclaration() {
        Lazy lazy = this.templateExtensionsDeclaration$delegate;
        return (KSClassDeclaration)lazy.getValue();
    }

    private final KSClassDeclaration getArrayDeclaration() {
        Lazy lazy = this.arrayDeclaration$delegate;
        return (KSClassDeclaration)lazy.getValue();
    }

    @NotNull
    public final Set<String> getUsedParams() {
        return this.referencedParams;
    }

    @NotNull
    public final ExprEvalResult validate(@NotNull String expression, @NotNull Map<String, ? extends KSType> paramMap) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(paramMap, (String)"paramMap");
        ExprNode node = this.exprNodeFactory.get(expression);
        KSType type = this.visit(node, paramMap);
        return new ExprEvalResult(node, type);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KSType visit(ExprNode node, Map<String, ? extends KSType> paramMap) {
        KSType kSType;
        ExprNode exprNode = node;
        if (exprNode instanceof ExprNode.Not) {
            kSType = this.perform(((ExprNode.Not)node).getLocation(), ((ExprNode.Not)node).getOperand(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.And) {
            kSType = this.perform(((ExprNode.And)node).getLocation(), ((ExprNode.And)node).getLeft(), ((ExprNode.And)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Or) {
            kSType = this.perform(((ExprNode.Or)node).getLocation(), ((ExprNode.Or)node).getLeft(), ((ExprNode.Or)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Eq) {
            kSType = this.equal(((ExprNode.Eq)node).getLocation(), ((ExprNode.Eq)node).getLeft(), ((ExprNode.Eq)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Ne) {
            kSType = this.equal(((ExprNode.Ne)node).getLocation(), ((ExprNode.Ne)node).getLeft(), ((ExprNode.Ne)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Ge) {
            kSType = this.compare(((ExprNode.Ge)node).getLocation(), ((ExprNode.Ge)node).getLeft(), ((ExprNode.Ge)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Gt) {
            kSType = this.compare(((ExprNode.Gt)node).getLocation(), ((ExprNode.Gt)node).getLeft(), ((ExprNode.Gt)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Le) {
            kSType = this.compare(((ExprNode.Le)node).getLocation(), ((ExprNode.Le)node).getLeft(), ((ExprNode.Le)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Lt) {
            kSType = this.compare(((ExprNode.Lt)node).getLocation(), ((ExprNode.Lt)node).getLeft(), ((ExprNode.Lt)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Is) {
            kSType = this.visitIs(((ExprNode.Is)node).getLocation(), ((ExprNode.Is)node).getLeft(), ((ExprNode.Is)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.As) {
            kSType = this.visitAs(((ExprNode.As)node).getLocation(), ((ExprNode.As)node).getLeft(), ((ExprNode.As)node).getRight(), paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Literal) {
            KType kType = ((ExprNode.Literal)node).getType();
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Byte.TYPE))) {
                kSType = this.context.getResolver().getBuiltIns().getByteType();
                return kSType;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Short.TYPE))) {
                kSType = this.context.getResolver().getBuiltIns().getShortType();
                return kSType;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Integer.TYPE))) {
                kSType = this.context.getResolver().getBuiltIns().getIntType();
                return kSType;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Long.TYPE))) {
                kSType = this.context.getResolver().getBuiltIns().getLongType();
                return kSType;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Float.TYPE))) {
                kSType = this.context.getResolver().getBuiltIns().getFloatType();
                return kSType;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Double.TYPE))) {
                kSType = this.context.getResolver().getBuiltIns().getDoubleType();
                return kSType;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Character.TYPE))) {
                kSType = this.context.getResolver().getBuiltIns().getCharType();
                return kSType;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Boolean.TYPE))) {
                kSType = this.context.getResolver().getBuiltIns().getBooleanType();
                return kSType;
            } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(String.class))) {
                kSType = this.context.getResolver().getBuiltIns().getStringType();
                return kSType;
            } else {
                String string;
                KClass klass;
                KClassifier kClassifier = ((ExprNode.Literal)node).getType().getClassifier();
                KClass kClass = klass = kClassifier instanceof KClass ? (KClass)kClassifier : null;
                if (klass == null || (string = klass.getQualifiedName()) == null) throw new ExprException("The type \"" + ((ExprNode.Literal)node).getType() + "\" is not found at " + ((ExprNode.Literal)node).getLocation());
                String string2 = string;
                boolean bl = false;
                KSName kSName = this.context.getResolver().getKSNameFromString(string2);
                if (kSName == null) throw new ExprException("The type \"" + ((ExprNode.Literal)node).getType() + "\" is not found at " + ((ExprNode.Literal)node).getLocation());
                KSName it = kSName;
                boolean bl2 = false;
                KSClassDeclaration kSClassDeclaration = this.context.getResolver().getClassDeclarationByName(it);
                Object object = kSClassDeclaration != null ? kSClassDeclaration.asStarProjectedType() : null;
                if (object == null) throw new ExprException("The type \"" + ((ExprNode.Literal)node).getType() + "\" is not found at " + ((ExprNode.Literal)node).getLocation());
                kSType = object;
            }
            return kSType;
        } else if (exprNode instanceof ExprNode.Comma) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((ExprNode.Comma)node).getNodeList();
            boolean bl = false;
            Iterable iterable = $this$map$iv;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean bl3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExprNode exprNode2 = (ExprNode)item$iv$iv;
                Collection collection2 = collection;
                boolean bl4 = false;
                collection2.add(this.visit((ExprNode)it, paramMap));
            }
            List types = (List)collection;
            kSType = new KSTypeList(types);
            return kSType;
        } else if (exprNode instanceof ExprNode.ClassRef) {
            kSType = this.visitClassRef((ExprNode.ClassRef)node, paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Value) {
            kSType = this.visitValue((ExprNode.Value)node, paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.CallableValue) {
            kSType = this.visitCallableValue((ExprNode.CallableValue)node, paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Property) {
            kSType = this.visitProperty((ExprNode.Property)node, paramMap);
            return kSType;
        } else if (exprNode instanceof ExprNode.Function) {
            kSType = this.visitFunction((ExprNode.Function)node, paramMap);
            return kSType;
        } else {
            if (!(exprNode instanceof ExprNode.Empty)) throw new NoWhenBranchMatchedException();
            kSType = this.context.getResolver().getBuiltIns().getUnitType();
        }
        return kSType;
    }

    private final KSType perform(ExprLocation location, ExprNode operand, Map<String, ? extends KSType> paramMap) {
        KSType result = this.visit(operand, paramMap);
        if (!Intrinsics.areEqual((Object)result, (Object)this.booleanType)) {
            throw new NonBooleanTypeException("Cannot perform the logical operator because the operand is not Boolean at " + location);
        }
        return this.booleanType;
    }

    private final KSType perform(ExprLocation location, ExprNode leftNode, ExprNode rightNode, Map<String, ? extends KSType> paramMap) {
        KSType left = this.visit(leftNode, paramMap);
        KSType right = this.visit(rightNode, paramMap);
        if (!Intrinsics.areEqual((Object)left, (Object)this.booleanType) || !Intrinsics.areEqual((Object)right, (Object)this.booleanType)) {
            throw new EitherOperandNonBooleanException("Cannot perform the logical operator because either operands is not Boolean at " + location);
        }
        return this.booleanType;
    }

    private final KSType equal(ExprLocation location, ExprNode leftNode, ExprNode rightNode, Map<String, ? extends KSType> paramMap) {
        this.visit(leftNode, paramMap);
        this.visit(rightNode, paramMap);
        return this.booleanType;
    }

    private final KSType compare(ExprLocation location, ExprNode leftNode, ExprNode rightNode, Map<String, ? extends KSType> paramMap) {
        KSType right;
        KSType left = this.visit(leftNode, paramMap);
        if (!Intrinsics.areEqual((Object)left, (Object)(right = this.visit(rightNode, paramMap)))) {
            throw new NonSameTypeException("Cannot compare because the operands(left=" + left + ", right=" + right + ") are not the same type at " + location);
        }
        if (!this.getComparableType().isAssignableFrom(left)) {
            throw new NonComparableTypeException("Cannot compare because operands(left=" + left + ", right=" + right + ") are not Comparable type at " + location);
        }
        return this.booleanType;
    }

    private final KSType visitIs(ExprLocation location, ExprNode leftNode, ExprNode rightNode, Map<String, ? extends KSType> paramMap) {
        KSType left = this.visit(leftNode, paramMap);
        if ((rightNode instanceof ExprNode.ClassRef ? (ExprNode.ClassRef)rightNode : null) == null) {
            throw new NotClassRefNodeException("The right operand of the \"is\" operator must be a class reference at " + location);
        }
        this.visitClassRef((ExprNode.ClassRef)rightNode, paramMap);
        return this.booleanType;
    }

    private final KSType visitAs(ExprLocation location, ExprNode leftNode, ExprNode rightNode, Map<String, ? extends KSType> paramMap) {
        KSType left = this.visit(leftNode, paramMap);
        if ((rightNode instanceof ExprNode.ClassRef ? (ExprNode.ClassRef)rightNode : null) == null) {
            throw new NotClassRefNodeException("The right operand of the \"as\" operator must be a class reference at " + location);
        }
        return this.visitClassRef((ExprNode.ClassRef)rightNode, paramMap);
    }

    private final KSType visitClassRef(ExprNode.ClassRef node, Map<String, ? extends KSType> paramMap) {
        String name = StringsKt.replace$default((String)node.getName(), (String)"$", (String)".", (boolean)false, (int)4, null);
        KSClassDeclaration classDeclaration2 = ContextKt.getClassDeclaration(this.context, name, new Function1(node){
            final /* synthetic */ ExprNode.ClassRef $node;
            {
                this.$node = $node;
            }

            public final Void invoke(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                throw new ClassNotFoundException("The class \"" + this.$node.getName() + "\" is not found at " + this.$node.getLocation());
            }
        });
        KSClassDeclaration companionObject = (KSClassDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)classDeclaration2.getDeclarations(), ExprValidator::visitClassRef$lambda$6), ExprValidator::visitClassRef$lambda$7));
        KSClassDeclaration kSClassDeclaration = companionObject;
        if (kSClassDeclaration == null || (kSClassDeclaration = kSClassDeclaration.asStarProjectedType()) == null) {
            kSClassDeclaration = classDeclaration2.asStarProjectedType();
        }
        return kSClassDeclaration;
    }

    private final KSType visitValue(ExprNode.Value node, Map<String, ? extends KSType> paramMap) {
        return this.getParamType(node.getName(), node.getLocation(), paramMap);
    }

    private final KSType visitCallableValue(ExprNode.CallableValue node, Map<String, ? extends KSType> paramMap) {
        List argList;
        KSType type = this.getParamType(node.getName(), node.getLocation(), paramMap);
        KSDeclaration kSDeclaration = type.getDeclaration();
        KSClassDeclaration kSClassDeclaration = kSDeclaration instanceof KSClassDeclaration ? (KSClassDeclaration)kSDeclaration : null;
        if (kSClassDeclaration == null) {
            throw new ExprException("The variable \"" + node.getName() + "\" is not a class at " + node.getLocation() + ".");
        }
        KSClassDeclaration classDeclaration2 = kSClassDeclaration;
        KSFunctionDeclaration kSFunctionDeclaration = (KSFunctionDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)UtilsKt.getDeclaredFunctions((KSClassDeclaration)classDeclaration2), ExprValidator::visitCallableValue$lambda$8));
        if (kSFunctionDeclaration == null) {
            throw new InvokeFunctionNotFoundException("The variable \"" + node.getName() + "\" does not have a invoke function at " + node.getLocation() + ".");
        }
        KSFunctionDeclaration functionDeclaration = kSFunctionDeclaration;
        KSType args = this.visit(node.getArgs(), paramMap);
        List list = args instanceof KSTypeList ? ((KSTypeList)args).getArgList() : (argList = Intrinsics.areEqual((Object)args, (Object)this.unitType) ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)args));
        if (functionDeclaration.getParameters().size() != argList.size()) {
            throw new ArgumentCountMismatchException("The number of arguments is not matched at " + node.getLocation());
        }
        KSTypeArgument kSTypeArgument = (KSTypeArgument)CollectionsKt.firstOrNull((List)type.getArguments());
        if (kSTypeArgument == null || (kSTypeArgument = kSTypeArgument.getType()) == null || (kSTypeArgument = kSTypeArgument.resolve()) == null) {
            throw new ReturnTypeNotFoundException("The return type is not found at " + node.getLocation());
        }
        return kSTypeArgument;
    }

    private final KSType getParamType(String name, ExprLocation location, Map<String, ? extends KSType> paramMap) {
        this.referencedParams.add(name);
        KSType kSType = paramMap.get(name);
        if (kSType == null) {
            throw new ParameterNotFoundException("The parameter \"" + name + "\" is not found at " + location + ". Available parameters are: " + paramMap.keySet() + ".");
        }
        return kSType;
    }

    private final KSType visitProperty(ExprNode.Property node, Map<String, ? extends KSType> paramMap) {
        KSType receiver = this.visit(node.getReceiver(), paramMap);
        KSType kSType = this.findProperty(node.getName(), receiver);
        if (kSType == null && (kSType = this.findExtensionProperty(node.getName(), receiver)) == null) {
            throw new PropertyNotFoundException("The property \"" + node.getName() + "\" is not found at " + node.getLocation());
        }
        return kSType;
    }

    private final KSType findProperty(String name, KSType receiver) {
        Object v1;
        KSPropertyDeclaration it;
        KSTypeReference $this$firstOrNull$iv;
        boolean $i$f$firstOrNull;
        KSClassDeclaration receiverDeclaration;
        KSDeclaration kSDeclaration;
        block6: {
            kSDeclaration = receiver.getDeclaration();
            KSClassDeclaration kSClassDeclaration = kSDeclaration instanceof KSClassDeclaration ? (KSClassDeclaration)kSDeclaration : null;
            if (kSClassDeclaration == null) {
                throw new ExprException("The receiver type is not a class: " + receiver.getDeclaration());
            }
            receiverDeclaration = kSClassDeclaration;
            Sequence sequence = receiverDeclaration.getAllProperties();
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (KSPropertyDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSimpleName().asString(), (Object)name)) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        kSDeclaration = v1;
        KSType propertyType = kSDeclaration != null && ($this$firstOrNull$iv = kSDeclaration.getType()) != null ? $this$firstOrNull$iv.resolve() : null;
        Object object = propertyType;
        if (object == null) {
            if (receiverDeclaration.getClassKind() == ClassKind.ENUM_CLASS) {
                Object v4;
                block7: {
                    Sequence $this$filterIsInstance$iv;
                    $this$firstOrNull$iv = receiverDeclaration.getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)findProperty$$inlined$filterIsInstance$1.INSTANCE);
                    Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                    $this$filterIsInstance$iv = SequencesKt.filter((Sequence)sequence, ExprValidator::findProperty$lambda$10);
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        it = (KSClassDeclaration)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getSimpleName().asString(), (Object)name)) continue;
                        v4 = element$iv;
                        break block7;
                    }
                    v4 = null;
                }
                kSDeclaration = v4;
                object = kSDeclaration != null ? kSDeclaration.asType(CollectionsKt.emptyList()) : null;
            } else {
                object = null;
            }
        }
        return object;
    }

    private final KSType findExtensionProperty(String name, KSType receiver) {
        KSTypeReference kSTypeReference;
        KSPropertyDeclaration kSPropertyDeclaration = (KSPropertyDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)this.getTemplateExtensionsDeclaration().getAllProperties(), arg_0 -> ExprValidator.findExtensionProperty$lambda$12(name, arg_0)), arg_0 -> ExprValidator.findExtensionProperty$lambda$13(receiver, arg_0)));
        return kSPropertyDeclaration != null && (kSTypeReference = kSPropertyDeclaration.getType()) != null ? kSTypeReference.resolve() : null;
    }

    private final KSType visitFunction(ExprNode.Function node, Map<String, ? extends KSType> paramMap) {
        List argList;
        KSType receiver = this.visit(node.getReceiver(), paramMap);
        KSType args = this.visit(node.getArgs(), paramMap);
        List list = argList = args instanceof KSTypeList ? ((KSTypeList)args).getArgList() : (Intrinsics.areEqual((Object)args, (Object)this.unitType) ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)args));
        KSType kSType = this.findFunction(node.getName(), receiver, argList);
        if (kSType == null && (kSType = this.findExtensionFunction(node.getName(), receiver, argList)) == null) {
            throw new FunctionNotFoundException("The function \"" + node.getName() + "\" (parameter size is " + argList.size() + ") is not found at " + node.getLocation());
        }
        return kSType;
    }

    private final KSType findFunction(String name, KSType receiver, List<? extends KSType> argList) {
        KSFunctionDeclaration kSFunctionDeclaration;
        KSDeclaration kSDeclaration = receiver.getDeclaration();
        KSClassDeclaration kSClassDeclaration = kSDeclaration instanceof KSClassDeclaration ? (KSClassDeclaration)kSDeclaration : null;
        if (kSClassDeclaration == null) {
            throw new ExprException("The receiver type is not a class: " + receiver.getDeclaration());
        }
        KSClassDeclaration receiverDeclaration = kSClassDeclaration;
        if (receiverDeclaration.getClassKind() == ClassKind.ENUM_CLASS) {
            if (Intrinsics.areEqual((Object)name, (Object)"valueOf") && argList.size() == 1 && Intrinsics.areEqual((Object)argList.get(0), (Object)this.stringType)) {
                return receiver;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"values") && argList.isEmpty()) {
                KSTypeReference typeRef = this.context.getResolver().createKSTypeReferenceFromKSType(receiver);
                KSTypeArgument typeArg = this.context.getResolver().getTypeArgument(typeRef, Variance.INVARIANT);
                return this.getArrayDeclaration().asType(CollectionsKt.listOf((Object)typeArg));
            }
        }
        return (kSFunctionDeclaration = (KSFunctionDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)receiverDeclaration.getAllFunctions(), arg_0 -> ExprValidator.findFunction$lambda$14(name, arg_0)), arg_0 -> ExprValidator.findFunction$lambda$15(argList, arg_0)), arg_0 -> ExprValidator.findFunction$lambda$17(argList, arg_0)))) != null && (kSDeclaration = kSFunctionDeclaration.getReturnType()) != null ? kSDeclaration.resolve() : null;
    }

    private final KSType findExtensionFunction(String name, KSType receiver, List<? extends KSType> argList) {
        KSTypeReference kSTypeReference;
        KSFunctionDeclaration kSFunctionDeclaration = (KSFunctionDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)this.getTemplateExtensionsDeclaration().getAllFunctions(), arg_0 -> ExprValidator.findExtensionFunction$lambda$18(name, arg_0)), arg_0 -> ExprValidator.findExtensionFunction$lambda$19(receiver, arg_0)), arg_0 -> ExprValidator.findExtensionFunction$lambda$20(argList, arg_0)), arg_0 -> ExprValidator.findExtensionFunction$lambda$22(argList, arg_0)));
        return kSFunctionDeclaration != null && (kSTypeReference = kSFunctionDeclaration.getReturnType()) != null ? kSTypeReference.resolve() : null;
    }

    private static final KSType comparableType_delegate$lambda$0(ExprValidator this$0) {
        return ContextKt.getClassDeclaration(this$0.context, Reflection.getOrCreateKotlinClass(Comparable.class), (Function1)comparableType.2.1.INSTANCE).asStarProjectedType();
    }

    private static final KSClassDeclaration templateExtensionsDeclaration_delegate$lambda$1(ExprValidator this$0) {
        return ContextKt.getClassDeclaration(this$0.context, this$0.context.getConfig().getTemplateExtensions(), (Function1)templateExtensionsDeclaration.2.1.INSTANCE);
    }

    private static final KSClassDeclaration arrayDeclaration_delegate$lambda$2(ExprValidator this$0) {
        return ContextKt.getClassDeclaration(this$0.context, Reflection.getOrCreateKotlinClass(Object[].class), (Function1)arrayDeclaration.2.1.INSTANCE);
    }

    private static final KSClassDeclaration visitClassRef$lambda$6(KSDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof KSClassDeclaration ? (KSClassDeclaration)it : null;
    }

    private static final boolean visitClassRef$lambda$7(KSClassDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isCompanionObject();
    }

    private static final boolean visitCallableValue$lambda$8(KSFunctionDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getSimpleName().asString(), (Object)"invoke");
    }

    private static final boolean findProperty$lambda$10(KSClassDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getClassKind() == ClassKind.ENUM_ENTRY;
    }

    private static final boolean findExtensionProperty$lambda$12(String $name, KSPropertyDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getSimpleName().asString(), (Object)$name);
    }

    private static final boolean findExtensionProperty$lambda$13(KSType $receiver, KSPropertyDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KSTypeReference kSTypeReference = it.getExtensionReceiver();
        return kSTypeReference != null && (kSTypeReference = kSTypeReference.resolve()) != null ? kSTypeReference.isAssignableFrom($receiver) : false;
    }

    private static final boolean findFunction$lambda$14(String $name, KSFunctionDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getSimpleName().asString(), (Object)$name);
    }

    private static final boolean findFunction$lambda$15(List $argList, KSFunctionDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParameters().size() == $argList.size();
    }

    private static final boolean findFunction$lambda$17(List $argList, KSFunctionDeclaration it) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)it.getParameters(), (Iterable)$argList);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    KSValueParameter param = (KSValueParameter)pair.component1();
                    KSType arg = (KSType)pair.component2();
                    if (param.getType().resolve().isAssignableFrom(arg)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean findExtensionFunction$lambda$18(String $name, KSFunctionDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getSimpleName().asString(), (Object)$name);
    }

    private static final boolean findExtensionFunction$lambda$19(KSType $receiver, KSFunctionDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KSTypeReference kSTypeReference = it.getExtensionReceiver();
        return kSTypeReference != null && (kSTypeReference = kSTypeReference.resolve()) != null ? kSTypeReference.isAssignableFrom($receiver) : false;
    }

    private static final boolean findExtensionFunction$lambda$20(List $argList, KSFunctionDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getParameters().size() == $argList.size();
    }

    private static final boolean findExtensionFunction$lambda$22(List $argList, KSFunctionDeclaration it) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)it.getParameters(), (Iterable)$argList);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    KSValueParameter param = (KSValueParameter)pair.component1();
                    KSType arg = (KSType)pair.component2();
                    if (param.getType().resolve().isAssignableFrom(arg)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$ArgumentCountMismatchException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class ArgumentCountMismatchException
    extends ExprException {
        public ArgumentCountMismatchException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$ClassNotFoundException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class ClassNotFoundException
    extends ExprException {
        public ClassNotFoundException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$EitherOperandNonBooleanException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class EitherOperandNonBooleanException
    extends ExprException {
        public EitherOperandNonBooleanException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$FunctionNotFoundException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class FunctionNotFoundException
    extends ExprException {
        public FunctionNotFoundException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$InvokeFunctionNotFoundException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class InvokeFunctionNotFoundException
    extends ExprException {
        public InvokeFunctionNotFoundException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0001H\u0016J\b\u0010 \u001a\u00020\u0015H\u0016J\b\u0010!\u001a\u00020\u0015H\u0016J\b\u0010\"\u001a\u00020\u0001H\u0016J\b\u0010#\u001a\u00020\u0001H\u0016J\u0016\u0010$\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0003H\u0016J\b\u0010%\u001a\u00020\u0001H\u0016J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u0019\u0010'\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010(\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010*H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0014\u0010\u0019\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lorg/komapper/processor/command/ExprValidator$KSTypeList;", "Lcom/google/devtools/ksp/symbol/KSType;", "argList", "", "<init>", "(Ljava/util/List;)V", "getArgList", "()Ljava/util/List;", "annotations", "Lkotlin/sequences/Sequence;", "Lcom/google/devtools/ksp/symbol/KSAnnotation;", "getAnnotations", "()Lkotlin/sequences/Sequence;", "arguments", "Lcom/google/devtools/ksp/symbol/KSTypeArgument;", "getArguments", "declaration", "Lcom/google/devtools/ksp/symbol/KSDeclaration;", "getDeclaration", "()Lcom/google/devtools/ksp/symbol/KSDeclaration;", "isError", "", "()Z", "isFunctionType", "isMarkedNullable", "isSuspendFunctionType", "nullability", "Lcom/google/devtools/ksp/symbol/Nullability;", "getNullability", "()Lcom/google/devtools/ksp/symbol/Nullability;", "isAssignableFrom", "that", "isCovarianceFlexible", "isMutabilityFlexible", "makeNotNullable", "makeNullable", "replace", "starProjection", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "komapper-processor"})
    public static final class KSTypeList
    implements KSType {
        @NotNull
        private final List<KSType> argList;

        public KSTypeList(@NotNull List<? extends KSType> argList) {
            Intrinsics.checkNotNullParameter(argList, (String)"argList");
            this.argList = argList;
        }

        @NotNull
        public final List<KSType> getArgList() {
            return this.argList;
        }

        @NotNull
        public Sequence<KSAnnotation> getAnnotations() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public List<KSTypeArgument> getArguments() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public KSDeclaration getDeclaration() {
            throw new UnsupportedOperationException();
        }

        public boolean isError() {
            throw new UnsupportedOperationException();
        }

        public boolean isFunctionType() {
            throw new UnsupportedOperationException();
        }

        public boolean isMarkedNullable() {
            throw new UnsupportedOperationException();
        }

        public boolean isSuspendFunctionType() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Nullability getNullability() {
            throw new UnsupportedOperationException();
        }

        public boolean isAssignableFrom(@NotNull KSType that) {
            Intrinsics.checkNotNullParameter((Object)that, (String)"that");
            throw new UnsupportedOperationException();
        }

        public boolean isCovarianceFlexible() {
            throw new UnsupportedOperationException();
        }

        public boolean isMutabilityFlexible() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public KSType makeNotNullable() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public KSType makeNullable() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public KSType replace(@NotNull List<? extends KSTypeArgument> arguments) {
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            throw new UnsupportedOperationException();
        }

        @NotNull
        public KSType starProjection() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public final List<KSType> component1() {
            return this.argList;
        }

        @NotNull
        public final KSTypeList copy(@NotNull List<? extends KSType> argList) {
            Intrinsics.checkNotNullParameter(argList, (String)"argList");
            return new KSTypeList(argList);
        }

        public static /* synthetic */ KSTypeList copy$default(KSTypeList kSTypeList, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = kSTypeList.argList;
            }
            return kSTypeList.copy(list);
        }

        @NotNull
        public String toString() {
            return "KSTypeList(argList=" + this.argList + ")";
        }

        public int hashCode() {
            return ((Object)this.argList).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof KSTypeList)) {
                return false;
            }
            KSTypeList kSTypeList = (KSTypeList)other;
            return Intrinsics.areEqual(this.argList, kSTypeList.argList);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$NonBooleanTypeException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class NonBooleanTypeException
    extends ExprException {
        public NonBooleanTypeException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$NonComparableTypeException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class NonComparableTypeException
    extends ExprException {
        public NonComparableTypeException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$NonSameTypeException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class NonSameTypeException
    extends ExprException {
        public NonSameTypeException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$NotClassRefNodeException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class NotClassRefNodeException
    extends ExprException {
        public NotClassRefNodeException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$ParameterNotFoundException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class ParameterNotFoundException
    extends ExprException {
        public ParameterNotFoundException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$PropertyNotFoundException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class PropertyNotFoundException
    extends ExprException {
        public PropertyNotFoundException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/komapper/processor/command/ExprValidator$ReturnTypeNotFoundException;", "Lorg/komapper/core/template/expression/ExprException;", "message", "", "<init>", "(Ljava/lang/String;)V", "komapper-processor"})
    public static final class ReturnTypeNotFoundException
    extends ExprException {
        public ReturnTypeNotFoundException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

