/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor.command;

import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSNode;
import java.util.Collection;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.komapper.core.template.sql.SqlException;
import org.komapper.processor.Context;
import org.komapper.processor.Exit;
import org.komapper.processor.ExitKt;
import org.komapper.processor.command.Partial;
import org.komapper.processor.command.PartialAnalysisResult;
import org.komapper.processor.command.PartialFactory;
import org.komapper.processor.command.SqlValidator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/komapper/processor/command/PartialAnalyzer;", "", "context", "Lorg/komapper/processor/Context;", "annotationClass", "Lkotlin/reflect/KClass;", "<init>", "(Lorg/komapper/processor/Context;Lkotlin/reflect/KClass;)V", "analyze", "Lorg/komapper/processor/command/PartialAnalysisResult;", "symbol", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "validatePartial", "", "partial", "Lorg/komapper/processor/command/Partial;", "komapper-processor"})
public final class PartialAnalyzer {
    @NotNull
    private final Context context;
    @NotNull
    private final KClass<?> annotationClass;

    public PartialAnalyzer(@NotNull Context context, @NotNull KClass<?> annotationClass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        this.context = context;
        this.annotationClass = annotationClass;
    }

    @NotNull
    public final PartialAnalysisResult analyze(@NotNull KSAnnotated symbol) {
        Partial partial;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        try {
            partial = new PartialFactory(this.context, this.annotationClass, symbol).create();
        }
        catch (Exit e) {
            return new PartialAnalysisResult.Error(e);
        }
        Partial partial2 = partial;
        if (!partial2.getDisableValidation()) {
            try {
                this.validatePartial(partial2);
            }
            catch (Exit e) {
                return new PartialAnalysisResult.Failure(partial2, e);
            }
        }
        return new PartialAnalysisResult.Success(partial2);
    }

    private final void validatePartial(Partial partial) {
        Set<String> set;
        try {
            set = new SqlValidator(this.context, partial.getSql(), partial.getParamMap(), null, null, 24, null).validate();
        }
        catch (SqlException e) {
            ExitKt.report("SQL validation error: " + e.getMessage(), (KSNode)partial.getAnnotation());
            throw new KotlinNothingValueException();
        }
        Set<String> usedParams = set;
        Set unusedParams = SetsKt.minus((Set)SetsKt.minus(partial.getParamMap().keySet(), (Iterable)usedParams), (Iterable)partial.getUnusedParams());
        if (!((Collection)unusedParams).isEmpty()) {
            this.context.getLogger().warn("Unused SQL params: " + unusedParams + ". You can suppress this warning message by specifying @KomapperUnused for the param properties.", (KSNode)partial.getClassDeclaration());
        }
    }
}

