/*
 * Decompiled with CFR 0.152.
 */
package org.komapper.processor.command;

import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.symbol.KSAnnotated;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.komapper.annotation.KomapperPartial;
import org.komapper.processor.Context;
import org.komapper.processor.ContextFactory;
import org.komapper.processor.Exit;
import org.komapper.processor.command.PartialAnalysisResult;
import org.komapper.processor.command.PartialAnalyzer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/komapper/processor/command/PartialProcessor;", "Lcom/google/devtools/ksp/processing/SymbolProcessor;", "contextFactory", "Lorg/komapper/processor/ContextFactory;", "<init>", "(Lorg/komapper/processor/ContextFactory;)V", "annotationClass", "Lkotlin/reflect/KClass;", "Lorg/komapper/annotation/KomapperPartial;", "process", "", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "log", "", "context", "Lorg/komapper/processor/Context;", "exit", "Lorg/komapper/processor/Exit;", "komapper-processor"})
public final class PartialProcessor
implements SymbolProcessor {
    @NotNull
    private final ContextFactory contextFactory;
    @NotNull
    private final KClass<KomapperPartial> annotationClass;

    public PartialProcessor(@NotNull ContextFactory contextFactory) {
        Intrinsics.checkNotNullParameter((Object)contextFactory, (String)"contextFactory");
        this.contextFactory = contextFactory;
        this.annotationClass = Reflection.getOrCreateKotlinClass(KomapperPartial.class);
    }

    @NotNull
    public List<KSAnnotated> process(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Context context = this.contextFactory.create(resolver);
        String string = this.annotationClass.getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        Sequence symbols = Resolver.getSymbolsWithAnnotation$default((Resolver)resolver, (String)string, (boolean)false, (int)2, null);
        Iterator iterator = symbols.iterator();
        while (iterator.hasNext()) {
            PartialAnalyzer analyzer = new PartialAnalyzer(context, this.annotationClass);
            KSAnnotated symbol = (KSAnnotated)iterator.next();
            PartialAnalysisResult result = analyzer.analyze(symbol);
            if (result instanceof PartialAnalysisResult.Success) continue;
            if (result instanceof PartialAnalysisResult.Failure) {
                this.log(context, ((PartialAnalysisResult.Failure)result).getExit());
                continue;
            }
            if (result instanceof PartialAnalysisResult.Error) {
                this.log(context, ((PartialAnalysisResult.Error)result).getExit());
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        return CollectionsKt.emptyList();
    }

    private final void log(Context context, Exit exit) {
        context.getLogger().error(exit.getReport().getMessage(), exit.getReport().getNode());
    }
}

